#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
""" pbkdf2"""

try:
    from hashlib import pbkdf2_hmac
except ImportError:
    from networking_huawei.third_party.hashlib import pbkdf2_hmac

ROUNDS = 100000
LENGTH = 32


def enable_pbkdf2(pwd, salt):
    """enable pbkdf2"""
    derivation_key = pbkdf2_hmac('sha256', pwd,
                                 salt, ROUNDS, dklen=LENGTH)
    return derivation_key
