#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""allocate vlan schema"""


import sqlalchemy as sa

try:
    from neutron.db import model_base
except ImportError:
    from neutron_lib.db import model_base
from oslo_utils import uuidutils


class AllocateVlanSchema(model_base.BASEV2):
    """Allocate Vlan Schema"""
    __tablename__ = 'huawei_ac_allocate_vlan'
    id = sa.Column(sa.String(36), primary_key=True,
                   default=uuidutils.generate_uuid)
    cluster_id = sa.Column(sa.String(36), nullable=False)
    network_id = sa.Column(sa.String(36), nullable=False)
    vlan = sa.Column(sa.String(36), nullable=False)
