#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""env class"""

from logging import config as logging_config

from alembic import context
from oslo_config import cfg
from oslo_db.sqlalchemy import session
import sqlalchemy as sa
from sqlalchemy import event

from neutron.db.migration.alembic_migrations import external

try:
    from neutron.db import model_base
except ImportError:
    from neutron_lib.db import model_base

MYSQL_ENGINE = None
AC_VERSION_TABLE = 'huawei_ac_alembic_version'
CONFIG = context.config
NEUTRON_CONFIG = CONFIG.neutron_config
logging_config.fileConfig(CONFIG.config_file_name)
DATABASE_NEUTRON_CONNECTION = NEUTRON_CONFIG.database.connection
DATABASE_NEUTRON_ENGINE = NEUTRON_CONFIG.database.engine
NEUTRON_CONFIG_COMMAND = NEUTRON_CONFIG.command
TARGET_METADATA = model_base.BASEV2.metadata


def set_mysql_engine():
    """ set mysql engine """
    try:
        mysql_engine = NEUTRON_CONFIG_COMMAND.mysql_engine
    except cfg.NoSuchOptError:
        mysql_engine = None

    global MYSQL_ENGINE
    MYSQL_ENGINE = mysql_engine if mysql_engine \
        else model_base.BASEV2.__table_args__['mysql_engine']


def include_object(table_obj, name, type_, reflected, compare_to):
    """ include object """
    flag = True
    if type_ == 'table' and name in external.TABLES:
        flag = False
    return flag


def run_migrations_offline():
    """ run migrations offline """
    set_mysql_engine()
    kwargs = dict()
    if DATABASE_NEUTRON_CONNECTION:
        kwargs['url'] = DATABASE_NEUTRON_CONNECTION
    else:
        kwargs['dialect_name'] = DATABASE_NEUTRON_ENGINE
    kwargs['version_table'] = AC_VERSION_TABLE
    kwargs['include_object'] = include_object
    context.configure(**kwargs)
    try:
        with context.begin_transaction():
            context.run_migrations()
    except Exception as ex:
        raise ex


@event.listens_for(sa.Table, 'after_parent_attach')
def set_storage_engine(target, parent):
    """ set storage engine """
    if not MYSQL_ENGINE:
        return
    target.kwargs['mysql_engine'] = MYSQL_ENGINE


def run_migrations_online():
    """ run migrations online """
    set_mysql_engine()
    engine = session.create_engine(DATABASE_NEUTRON_CONNECTION)
    kwargs = dict()
    kwargs['connection'] = engine.connect()
    kwargs['target_metadata'] = TARGET_METADATA
    kwargs['version_table'] = AC_VERSION_TABLE
    kwargs['include_object'] = include_object
    context.configure(**kwargs)

    try:
        with context.begin_transaction():
            context.run_migrations()
    finally:
        kwargs['connection'].close()
        engine.dispose()


if context.is_offline_mode():
    run_migrations_offline()
else:
    run_migrations_online()
