#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: he28f0c4ab76
Revises: g0ac3a5de152
Create Date: 2018-09-15 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration

revision = 'he28f0c4ab76'
down_revision = 'g0ac3a5de152'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    Create table huawei_ac_snat.
    """
    if not migration.schema_has_table('huawei_ac_snat'):
        op.create_table(
            'huawei_ac_snat',
            sa.Column('id', sa.String(36), nullable=False),
            sa.Column('name', sa.String(255), nullable=True),
            sa.Column('tenant_id', sa.String(255), nullable=False),
            sa.Column('router_id', sa.String(36), nullable=False),
            sa.Column('snat_network_id', sa.String(36), nullable=False),
            sa.Column('snat_ip_address', sa.String(64), nullable=True),
            sa.Column('snat_ip_pool', sa.PickleType, nullable=True),
            sa.Column('original_cidrs', sa.PickleType, nullable=True),
            sa.Column('type', sa.Integer, nullable=False),
            sa.PrimaryKeyConstraint('id'),
        )
