#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: j36d7e59ca85
Revises: i2549fee8af8
Create Date: 2018-09-19 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration

# revision identifiers, used by Alembic.
revision = 'j36d7e59ca85'
down_revision = 'i2549fee8af8'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    Add column local_cidrs to table huawei_ac_vpc_connection.
    Add column local_firewall_enable to table huawei_ac_vpc_connection.
    Add column peer_cidrs to table huawei_ac_vpc_connection.
    Add column peer_firewall_enable to table huawei_ac_vpc_connection.
    Add column mode to table huawei_ac_vpc_connection.
    Add column priority to table huawei_ac_vpc_connection.
    """
    if not migration.schema_has_column('huawei_ac_vpc_connection',
                                       'local_cidrs'):
        op.add_column(
            'huawei_ac_vpc_connection',
            sa.Column('local_cidrs', sa.PickleType, nullable=True)
        )

    if not migration.schema_has_column('huawei_ac_vpc_connection',
                                       'local_firewall_enable'):
        op.add_column(
            'huawei_ac_vpc_connection',
            sa.Column('local_firewall_enable', sa.Boolean, nullable=True)
        )

    if not migration.schema_has_column('huawei_ac_vpc_connection',
                                       'peer_cidrs'):
        op.add_column(
            'huawei_ac_vpc_connection',
            sa.Column('peer_cidrs', sa.PickleType, nullable=True)
        )

    if not migration.schema_has_column('huawei_ac_vpc_connection',
                                       'peer_firewall_enable'):
        op.add_column(
            'huawei_ac_vpc_connection',
            sa.Column('peer_firewall_enable', sa.Boolean, nullable=True)
        )

    if not migration.schema_has_column('huawei_ac_vpc_connection', 'mode'):
        op.add_column(
            'huawei_ac_vpc_connection',
            sa.Column('mode', sa.Integer(), default=0, nullable=True)
        )

    if not migration.schema_has_column('huawei_ac_vpc_connection', 'priority'):
        op.add_column(
            'huawei_ac_vpc_connection',
            sa.Column('priority', sa.Integer(), nullable=True)
        )
