#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: k8b9f89d309f
Revises: j36d7e59ca85
Create Date: 2018-10-13 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration

revision = 'k8b9f89d309f'
down_revision = 'j36d7e59ca85'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    Create table huawei_ac_exroute.
    """
    if not migration.schema_has_table('huawei_ac_exroute'):
        op.create_table(
            'huawei_ac_exroute',
            sa.Column('router_id', sa.String(length=36), nullable=False),
            sa.Column('destination', sa.String(length=64), nullable=False),
            sa.Column('nexthop', sa.String(length=64), nullable=False),
            sa.Column('ip_version', sa.Integer, default=4,
                      autoincrement=False),
            sa.Column('priority', sa.Integer, nullable=True,
                      autoincrement=False),
            sa.Column('type', sa.Integer, nullable=False, autoincrement=False),
            sa.Column('ports', sa.PickleType, nullable=True),
            sa.Column('extra_opt', sa.PickleType, nullable=True),
        )
