#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: p1279d19b98d
Revises: od3758325bbd
Create Date: 2019-09-03 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration

revision = 'p1279d19b98d'
down_revision = 'od3758325bbd'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    Alter column object_uuid to String(128) of table huawei_ac_locked_objects.
    """
    if migration.schema_has_column('huawei_ac_locked_objects', 'object_uuid'):
        op.alter_column(
            'huawei_ac_locked_objects', 'object_uuid',
            type_=sa.String(128),
            nullable=False
        )
