#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: s3v45gvu6hhj
Revises: ryvh5e4u3hsj
Create Date: 2020-03-25 15:38:03.285373

"""
import os
import netaddr
from alembic import op
import sqlalchemy as sa

revision = 's3v45gvu6hhj'
down_revision = 'ryvh5e4u3hsj'
depends_on = None
FUSIONSPHERE_OS = os.path.realpath('/etc/hostos.version')


def check_exroute_update(nexthop_org, destination_org):
    """check exroute need update or not"""
    try:
        destination_new = str(netaddr.IPNetwork(destination_org).cidr)
        nexthop_new = str(netaddr.IPAddress(nexthop_org))
        if destination_new != destination_org or nexthop_new != nexthop_org:
            return True, nexthop_new, destination_new
        return False, None, None
    except Exception:
        return False, None, None


def upgrade():
    """Upgrade exroute db"""
    exroute_table_name = 'huawei_ac_exroute'
    if os.path.exists(FUSIONSPHERE_OS):
        with open(FUSIONSPHERE_OS, mode='r') as fs_os:
            fs_os_content = fs_os.read()
            if fs_os_content.find('FUSIONSPHERE') != -1:
                exroute_table_name = 'routerexroutes'

    exroute_table = sa.Table(
        exroute_table_name,
        sa.MetaData(),
        sa.Column('router_id', sa.String(length=36), nullable=False),
        sa.Column('destination', sa.String(length=64), nullable=False),
        sa.Column('nexthop', sa.String(length=64), nullable=False),
    )

    session = sa.orm.Session(bind=op.get_bind())
    with session.begin(subtransactions=True):
        for elem in session.query(exroute_table):
            need_update, nexthop_new, destination_new = check_exroute_update(
                elem.nexthop, elem.destination)
            if not need_update:
                continue
            session.execute(exroute_table.update().values(
                destination=destination_new, nexthop=nexthop_new).where(
                    exroute_table.c.router_id == elem.router_id).where(
                        exroute_table.c.nexthop == elem.nexthop).where(
                            exroute_table.c.destination == elem.destination))
    session.commit()
