#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: s5e637h9n2df
Revises: ryvh5e4u3hsj
Create Date: 2020-02-28 15:36:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration
from sqlalchemy.engine.reflection import Inspector as insp

revision = 't5e637h9n2df'
down_revision = 's3v45gvu6hhj'
depends_on = None
MYSQL_ENGINE = 'mysql'


def upgrade():
    """Initialize Huawei AC mechanism driver DB.
    Alter column sync_type/exec_result/error_message to table
    huawei_ac_sync_results.
    Drop old primary key and create a new primary key for table
    huawei_ac_sync_results.
    """
    bind = op.get_bind()
    engine = bind.engine
    if not migration.schema_has_column('huawei_ac_sync_results', 'sync_type'):
        op.add_column(
            'huawei_ac_sync_results',
            sa.Column('sync_type', type_=sa.String(50), nullable=False,
                      server_default='inconsistency_recover'))

    if not migration.schema_has_column('huawei_ac_sync_results', 'exec_result'):
        op.add_column('huawei_ac_sync_results', sa.Column(
            'exec_result', type_=sa.String(50), nullable=True))

    if not migration.schema_has_column('huawei_ac_sync_results',
                                       'error_message'):
        op.add_column('huawei_ac_sync_results', sa.Column(
            'error_message', type_=sa.String(255), nullable=True))

    if engine.name == MYSQL_ENGINE:
        op.execute("ALTER TABLE huawei_ac_sync_results DROP PRIMARY KEY, "
                   "ADD PRIMARY KEY(id, sync_type);")
    else:
        inspector = insp.from_engine(bind)
        pk_constraint = inspector.get_pk_constraint('huawei_ac_sync_results')
        op.drop_constraint(pk_constraint.get('name'), 'huawei_ac_sync_results',
                           type_='primary')
        op.create_primary_key(op.f('pk_huawei_ac_sync_results'),
                              'huawei_ac_sync_results', ['id', 'sync_type'])
