#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: u3fniwe2wevd
Revises: t5e637h9n2df
Create Date: 2019-03-18 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration

revision = 'u3fniwe2wevd'
down_revision = 't66637h9n2df'
depends_on = None


def upgrade():
    """
    Initialize Huawei AC mechanism driver DB.

    Add column sdn_tapservice_name to table huawei_ac_tap_flows.
    """
    if not migration.schema_has_column('huawei_ac_tap_flows',
                                       'sdn_tapservice_name'):
        op.add_column(
            'huawei_ac_tap_flows',
            sa.Column('sdn_tapservice_name', sa.String(255), nullable=True)
        )
    if migration.schema_has_column('huawei_ac_tap_flows', 'tap_service_id'):
        op.alter_column(
            'huawei_ac_tap_flows', 'tap_service_id',
            type_=sa.String(48),
            nullable=True
        )
