#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""compare result extension"""

import abc

import six

from neutron.api import extensions

try:
    from neutron.api.extensions import ExtensionDescriptor
except ImportError:
    from neutron_lib.api.extensions import ExtensionDescriptor

try:
    from neutron.services.service_base import ServicePluginBase
except ImportError:
    from neutron_lib.services.base import ServicePluginBase

from networking_huawei.drivers.ac.extensions import compare_result \
    as compare_result_extension
from networking_huawei.drivers.ac.common import neutron_compatible_util as ncu
from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei.drivers.ac.extensions.sync_result.sync_result import \
    Sync_result


LOG = logging.getLogger(__name__)

extensions.append_api_extensions_path(compare_result_extension.__path__)

OPS_VERSION = ncu.get_ops_version()

COMPARE_RESULT = 'compare_result'

# Attribute Map
RESOURCE_ATTRIBUTE_MAP = {
    'compare_results': {
        'id': {
            'allow_post': False, 'allow_put': False,
            'validate': {'type:uuid_or_none': None},
            'is_visible': True},
        'res_name': {
            'allow_post': False, 'allow_put': False,
            'validate': {'type:string': 255},
            'is_visible': True},
        'res_type': {
            'allow_post': False, 'allow_put': False,
            'validate': {'type:string': 50},
            'is_visible': True},
        'tenant_name': {
            'allow_post': False, 'allow_put': False,
            'validate': {'type:string': 255},
            'is_visible': True},
        'create_time': {
            'allow_post': False, 'allow_put': False,
            'validate': {'type:string': 255},
            'is_visible': True},
        'update_time': {
            'allow_post': False, 'allow_put': False,
            'validate': {'type:string': 255},
            'is_visible': True},
        'status': {
            'allow_post': False, 'allow_put': False,
            'validate': {'type:string': 50},
            'is_visible': True},
    }
}


class Compare_result(ExtensionDescriptor):
    """Perform neutron compare through cli"""

    @classmethod
    def get_name(cls):
        """Name for this extension"""
        return "compare_result"

    @classmethod
    def get_alias(cls):
        """core_plugin class to load the extension"""
        return 'compare_result'

    @classmethod
    def get_description(cls):
        """A small description about this extension"""
        return "Get neutron compare results"

    @classmethod
    def get_namespace(cls):
        """The XML namespace for this extension"""
        return ""

    @classmethod
    def get_updated(cls):
        """Specify when was this extension last updated"""
        return "2017-02-8T19:48:50-00:00"

    @classmethod
    def get_resources(cls):
        """Returns Ext Resources."""
        return Sync_result.get_resources_core(COMPARE_RESULT, [COMPARE_RESULT])

    @classmethod
    def get_plugin_interface(cls):
        """get plugin interface"""
        return CompareresultBase

    def update_attributes_map(self, attributes, extension_attrs_map=None):
        """update attributes map"""
        super(Compare_result, self).update_attributes_map(
            attributes, extension_attrs_map=RESOURCE_ATTRIBUTE_MAP)

    def get_extended_resources(self, version):
        """get extended resources"""
        if version != "2.0":
            return {}
        return RESOURCE_ATTRIBUTE_MAP


@six.add_metaclass(abc.ABCMeta)
class CompareresultBase(ServicePluginBase):
    """compare result class"""

    def get_plugin_type(self):
        """get plugin type"""
        pass

    def get_plugin_description(self):
        """get plugin description"""
        return 'Get neutron compare results'

    def get_plugin_name(self):
        """get plugin name"""
        pass

    @abc.abstractmethod
    def get_compare_results(self, context, filters=None, fields=None,
                            sorts=None, limit=None, marker_obj=None,
                            page_reverse=False):
        """the abstractmethod to get compare result"""
        pass
