#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""sync result plugin"""

import abc
import six
from oslo_config import cfg

try:
    from neutron_lib.plugins import directory
except Exception:
    directory = None
from neutron import manager

from neutron.api.v2 import base

from neutron.api import extensions

try:
    from neutron.api.extensions import ExtensionDescriptor
except ImportError:
    from neutron_lib.api.extensions import ExtensionDescriptor
try:
    from neutron.services.service_base import ServicePluginBase
except ImportError:
    from neutron_lib.services.base import ServicePluginBase

import networking_huawei.drivers.ac.common.constants as ac_constants
from networking_huawei.drivers.ac.extensions import sync_result \
    as sync_result_extension
from networking_huawei.drivers.ac.common import neutron_compatible_util as ncu
from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging

LOG = logging.getLogger(__name__)

extensions.append_api_extensions_path(sync_result_extension.__path__)

OPS_VERSION = ncu.get_ops_version()

SYNC_RESULT = 'sync_result'

# Attribute Map
RESOURCE_ATTRIBUTE_MAP = {
    'sync_results': {
        'id': {
            'allow_post': False, 'allow_put': False, 'is_visible': True,
            'validate': {'type:string': 255}},
        'tenant_name': {
            'allow_post': False, 'allow_put': False,
            'validate': {'type:string': 255},
            'is_visible': True},
        'res_name': {
            'allow_post': False, 'allow_put': False, 'is_visible': True,
            'validate': {'type:string': 255}},
        'res_type': {
            'allow_post': False, 'allow_put': False,
            'validate': {'type:string': 50}, 'is_visible': True},
        'status': {
            'allow_post': False, 'allow_put': False, 'is_visible': True,
            'validate': {'type:string': 50}},
        'create_time': {
            'allow_post': False, 'allow_put': False,
            'validate': {'type:string': 255}, 'is_visible': True},
        'update_time': {
            'allow_post': False, 'allow_put': False,
            'validate': {'type:string': 255}, 'is_visible': True},
        'oper': {
            'allow_post': False, 'allow_put': False,
            'validate': {'type:string': 50},
            'is_visible': True},
        'sync_id': {
            'allow_post': False, 'allow_put': False,
            'validate': {'type:uuid_or_none': None},
            'is_visible': True},
        'sync_end_time': {
            'allow_post': False, 'allow_put': False,
            'validate': {'type:string': 255},
            'is_visible': True},
        'sync_start_time': {
            'allow_post': False, 'allow_put': False,
            'validate': {'type:string': 255},
            'is_visible': True},
        'total_time_used': {
            'allow_post': False, 'allow_put': False,
            'validate': {'type:string': 255},
            'is_visible': True},
        'total_sync_resources': {
            'allow_post': False, 'allow_put': False,
            'validate': {'type:string': 255},
            'is_visible': True},
        'total_create_resources': {
            'allow_post': False, 'allow_put': False,
            'validate': {'type:string': 255},
            'is_visible': True},
        'total_update_resources': {
            'allow_post': False, 'allow_put': False,
            'validate': {'type:string': 255},
            'is_visible': True},
        'total_delete_resources': {
            'allow_post': False, 'allow_put': False,
            'validate': {'type:string': 255},
            'is_visible': True},
    }
}


class Sync_result(ExtensionDescriptor):
    """Perform neutron sync through cli"""

    @classmethod
    def get_name(cls):
        """Name for this extension"""
        return "sync_result"

    @classmethod
    def get_alias(cls):
        """core_plugin class to load the extension"""
        return 'sync_result'

    @classmethod
    def get_description(cls):
        """A small description about this extension"""
        return "Get neutron sync results"

    @classmethod
    def get_namespace(cls):
        """The XML namespace for this extension"""
        return ""

    @classmethod
    def get_updated(cls):
        """Specify when was this extension last updated"""
        return "2017-02-8T19:48:50-00:00"

    @classmethod
    def get_resources(cls):
        """Returns Ext Resources."""
        return cls.get_resources_core(SYNC_RESULT, [SYNC_RESULT])

    @classmethod
    def get_resources_core(cls, plugin_key, res_list):
        """call by Sync_result and Compare_result"""
        allow_pagination, allow_sorting, plugin = cls.get_resource_before(
            plugin_key)
        resources = []
        for resource_name in res_list:
            collection_name = resource_name + 's'
            params = RESOURCE_ATTRIBUTE_MAP.get(collection_name, dict())
            member_actions = {}
            controller = base.create_resource(
                collection_name, resource_name, plugin, params, allow_bulk=True,
                allow_sorting=allow_sorting, member_actions=member_actions,
                allow_pagination=allow_pagination)
            resources.append(extensions.ResourceExtension(
                collection_name, controller, attr_map=params,
                member_actions=member_actions))
        return resources

    @classmethod
    def get_resource_before(cls, plugin_key):
        """get_resources_core call"""
        if OPS_VERSION in ac_constants.OPS_VERSION_O_PQRTW_6_21:
            allow_pagination = True
            allow_sorting = True
            plugin = directory.get_plugin(plugin_key)
        else:
            plugin = manager.NeutronManager.get_service_plugins()[plugin_key]
            allow_pagination = cfg.CONF.allow_pagination
            allow_sorting = cfg.CONF.allow_sorting
        return allow_pagination, allow_sorting, plugin

    @classmethod
    def get_plugin_interface(cls):
        """get plugin interface"""
        return SyncresultBase

    def update_attributes_map(self, attributes, extension_attrs_map=None):
        """update attributes map"""
        super(Sync_result, self).update_attributes_map(
            attributes, extension_attrs_map=RESOURCE_ATTRIBUTE_MAP)

    def get_extended_resources(self, version):
        """get extended resources"""
        if version != "2.0":
            return {}
        return RESOURCE_ATTRIBUTE_MAP


@six.add_metaclass(abc.ABCMeta)
class SyncresultBase(ServicePluginBase):
    """Syncresult class"""

    def get_plugin_type(self):
        """get plugin type"""
        pass

    def get_plugin_description(self):
        """get plugin description"""
        return 'Get neutron sync results'

    def get_plugin_name(self):
        """get plugin name"""
        pass

    @abc.abstractmethod
    def get_sync_results(self, context, filters=None, fields=None,
                         sorts=None, limit=None, marker_obj=None,
                         page_reverse=False):
        """the abstractmethod to get bgpneighbors"""
        pass
