#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""firewall model"""

from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei._i18n import _LE

LOG = logging.getLogger(__name__)


class ACFirewallModel(object):
    """ACFirewallModel"""

    @staticmethod
    def ac_model_format(firewall):
        """Convert data to AC model"""
        try:

            fw_info = {
                'name': firewall['name'],
                'tenant-id': firewall['tenant_id']
            }

            if firewall.get('id') is not None:
                fw_info['uuid'] = firewall['id']

            if firewall.get('description') is not None:
                fw_info['descr'] = firewall['description']

            if firewall.get('admin_state_up') is not None:
                fw_info['admin-state-up'] = firewall['admin_state_up']

            if firewall.get('shared') is not None:
                fw_info['shared'] = firewall['shared']

            if firewall.get('firewall_policy_id') is not None:
                fw_info['firewall-policy-id'] = \
                    firewall['firewall_policy_id']

            # need to give fw_info['router-ids'] = [] to AC
            # when fw disassociate router
            if 'router_ids' in firewall:
                fw_info['router-ids'] = firewall['router_ids']

            if firewall.get('status') is not None:
                fw_info['status'] = firewall['status']

        except KeyError as value:
            LOG.error(_LE("[AC]Key Error, doesn't contain all fields %s."),
                      value)
            raise KeyError

        return fw_info
