#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""firewall rule model"""

from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei._i18n import _LE

LOG = logging.getLogger(__name__)


class ACFirewallRuleModel(object):
    """ACFirewallRuleModel"""

    @staticmethod
    def ac_model_format(firewall_rule):
        """Convert data to AC model"""
        try:

            fw_rule_info = {
                'name': firewall_rule['name'],
                'tenant-id': firewall_rule['tenant_id']
            }

            if firewall_rule.get('id') is not None:
                fw_rule_info['uuid'] = firewall_rule['id']

            if firewall_rule.get('description') is not None:
                fw_rule_info['descr'] = firewall_rule['description']

            ACFirewallRuleModel. \
                get_firewall_protocol(firewall_rule, fw_rule_info)

            if firewall_rule.get('action') is not None:
                fw_rule_info['action'] = firewall_rule['action']

            ACFirewallRuleModel.get_ip_address(firewall_rule, fw_rule_info)
            ACFirewallRuleModel.get_firewall_ports(firewall_rule, fw_rule_info)

            if firewall_rule.get('shared') is not None:
                fw_rule_info['shared'] = firewall_rule['shared']

            if firewall_rule.get('status') is not None:
                fw_rule_info['status'] = firewall_rule['status']

            if firewall_rule.get('enabled') is not None:
                fw_rule_info['enabled'] = firewall_rule['enabled']

            if firewall_rule.get('position') is not None:
                fw_rule_info['position'] = firewall_rule['position']

            if firewall_rule.get('ip_version') is not None:
                fw_rule_info['ip-version'] = firewall_rule['ip_version']

        except KeyError as value:
            LOG.error(_LE("[AC]Key Error, doesn't contain all fields %s."),
                      value)
            raise KeyError

        return fw_rule_info

    @staticmethod
    def get_source_ip_addresses(firewall_rule, fw_rule_info):
        """get_source_ip_addresses"""
        source_ip_addresses = firewall_rule.get('source_ip_addresses', '')
        if isinstance(source_ip_addresses, list):
            if not source_ip_addresses:
                fw_rule_info['source-ip-addrs'] = ''
            else:
                fw_rule_info['source-ip-addrs'] = ','.join(source_ip_addresses)
        else:
            if source_ip_addresses is None:
                fw_rule_info['source-ip-addrs'] = ''
            else:
                fw_rule_info['source-ip-addrs'] = source_ip_addresses

    @staticmethod
    def get_destination_ip_addresses(firewall_rule, fw_rule_info):
        """get_destination_ip_addresses"""
        destination_ip_addresses = firewall_rule.get('destination_ip_addresses', '')
        if isinstance(destination_ip_addresses, list):
            if not destination_ip_addresses:
                fw_rule_info['destination-ip-addrs'] = ''
            else:
                fw_rule_info['destination-ip-addrs'] = ','.join(destination_ip_addresses)
        else:
            if destination_ip_addresses is None:
                fw_rule_info['destination-ip-addrs'] = ''
            else:
                fw_rule_info['destination-ip-addrs'] = destination_ip_addresses

    @staticmethod
    def get_ip_address(firewall_rule, fw_rule_info):
        """get_ip_address"""
        if 'source_ip_address' in firewall_rule:
            fw_rule_info['source-ip-addr'] = \
                firewall_rule['source_ip_address'] or ''

        if 'destination_ip_address' in firewall_rule:
            fw_rule_info['destination-ip-addr'] = \
                firewall_rule['destination_ip_address'] or ''

        if 'source_ip_addresses' in firewall_rule:
            ACFirewallRuleModel.\
                get_source_ip_addresses(firewall_rule, fw_rule_info)

        if 'destination_ip_addresses' in firewall_rule:
            ACFirewallRuleModel.\
                get_destination_ip_addresses(firewall_rule, fw_rule_info)

    @staticmethod
    def get_source_ports(firewall_rule, fw_rule_info):
        """get_source_ports"""
        source_ports = firewall_rule.get('source_ports', '')
        if isinstance(source_ports, list):
            if not source_ports:
                fw_rule_info['source-ports'] = ''
            else:
                fw_rule_info['source-ports'] = ','.join(source_ports)
        else:
            if source_ports is None:
                fw_rule_info['source-ports'] = ''
            else:
                fw_rule_info['source-ports'] = source_ports

    @staticmethod
    def get_destination_ports(firewall_rule, fw_rule_info):
        """get_destination_ports"""
        destination_ports = firewall_rule.get('destination_ports', '')
        if isinstance(destination_ports, list):
            if not destination_ports:
                fw_rule_info['destination-ports'] = ''
            else:
                fw_rule_info['destination-ports'] = ','.join(destination_ports)
        else:
            if destination_ports is None:
                fw_rule_info['destination-ports'] = ''
            else:
                fw_rule_info['destination-ports'] = destination_ports

    @staticmethod
    def get_firewall_ports(firewall_rule, fw_rule_info):
        """get_firewall_ports"""
        if 'source_port' in firewall_rule:
            fw_rule_info['source-port'] = firewall_rule['source_port'] or ''

        if 'destination_port' in firewall_rule:
            fw_rule_info['destination-port'] = \
                firewall_rule['destination_port'] or ''

        if 'source_ports' in firewall_rule:
            ACFirewallRuleModel.get_source_ports(firewall_rule, fw_rule_info)

        if 'destination_ports' in firewall_rule:
            ACFirewallRuleModel.\
                get_destination_ports(firewall_rule, fw_rule_info)

    @staticmethod
    def get_firewall_protocol(firewall_rule, fw_rule_info):
        """get_firewall_protocol"""
        if 'protocol' in firewall_rule:
            fw_rule_info['protocol'] = firewall_rule['protocol']
            if firewall_rule['protocol'] is None:
                fw_rule_info['protocol'] = 'any'
