#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2020 Huawei Technologies Co. Ltd. All rights reserved.
"""flow mirror model"""
from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei._i18n import _LE

LOG = logging.getLogger(__name__)


class ACFlowMirrorModel(object):
    """ AC Flow Mirror Model """
    @staticmethod
    def ac_model_format_service(tap_service_db):
        """ ac model format service """
        try:
            tap_service_info = {
                'uuid': tap_service_db['id'],
                'name': tap_service_db['name'],
                'tenant_id': tap_service_db['tenant_id'],
                'description': tap_service_db['description']
            }
            if tap_service_db.get('port_id'):
                tap_service_info['port_id'] = \
                    tap_service_db['port_id']
            if tap_service_db.get('remote_v4ip'):
                remote_v4ip_arr = [tap_service_db['remote_v4ip']]
                tap_service_info['remote_v4ip'] = remote_v4ip_arr
            if tap_service_db.get('remote_v6ip'):
                remote_v6ip_arr = [tap_service_db['remote_v6ip']]
                tap_service_info['remote_v6ip'] = remote_v6ip_arr
        except KeyError as ex:
            LOG.error(_LE("[AC] Construct tap service info error, "
                          "doesn't contain all fields: %s."), ex)
            raise ex
        return tap_service_info

    @staticmethod
    def ac_model_format_flow(tap_flow_db):
        """ ac model format flow """
        try:
            tap_flow_info = {
                'uuid': tap_flow_db['id'],
                'name': tap_flow_db['name'],
                'tenant_id': tap_flow_db['tenant_id'],
                'source_port': tap_flow_db['source_port'],
                'description': tap_flow_db['description'],
                'direction': tap_flow_db['direction']
            }
            if tap_flow_db.get('sdn_tapservice_name'):
                tap_flow_info['sdnTapServiceName'] = \
                    tap_flow_db['sdn_tapservice_name']
            if tap_flow_db.get('tap_service_id'):
                tap_flow_info['tap_service_id'] = \
                    tap_flow_db['tap_service_id']
            if tap_flow_db.get('destination_v4ip_prefix'):
                tap_flow_info['destination_v4ip_prefix'] = \
                    tap_flow_db['destination_v4ip_prefix']
            if tap_flow_db.get('destination_v6ip_prefix'):
                tap_flow_info['destination_v6ip_prefix'] = \
                    tap_flow_db['destination_v6ip_prefix']
        except KeyError as ex:
            LOG.error(_LE("[AC] Construct tap flow info error, "
                          "doesn't contain all fields: %s."), ex)
            raise ex
        return tap_flow_info
