#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""ipsec vpn model"""

from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei._i18n import _LE

LOG = logging.getLogger(__name__)


class ACVPNServiceModel(object):
    """ACVPNServiceModel"""
    @staticmethod
    def ac_model_format(vpnservice_db, tenant_name):
        """ac_model_format"""
        try:
            vpnservice_info = {
                'uuid': vpnservice_db['id'],
                'name': vpnservice_db['name'],
                'tenant-id': vpnservice_db['tenant_id'],
                'tenant-name': tenant_name,
                'admin-state-up': vpnservice_db['admin_state_up'],
                'descr': vpnservice_db['description'],
                'router-id': vpnservice_db['router_id']
            }
            if vpnservice_db.get('subnet_id'):
                vpnservice_info['subnet-id'] = vpnservice_db['subnet_id']
            if vpnservice_db.get('external_v4_ip'):
                vpnservice_info['external-v4-ip'] = \
                    vpnservice_db['external_v4_ip']
        except KeyError as value:
            LOG.error(_LE("[AC]Construct vpn service info error, "
                          "doesn't contain all fields : %s."), value)
            raise KeyError

        return vpnservice_info


class ACIKEpolicyModel(object):
    """ACIKEpolicyModel"""
    @staticmethod
    def ac_model_format(ikepolicy_db, tenant_name):
        """ac_model_format"""
        try:
            ikepolicy_info = {
                'uuid': ikepolicy_db['id'],
                'name': ikepolicy_db['name'],
                'tenant-id': ikepolicy_db['tenant_id'],
                'tenant-name': tenant_name,
                'descr': ikepolicy_db['description'],
                'auth-algorithm': ikepolicy_db['auth_algorithm'],
                'encryption-algorithm':
                    ikepolicy_db['encryption_algorithm'],
                'phase-negotiation-mode':
                    ikepolicy_db['phase1_negotiation_mode'],
                'pfs': ikepolicy_db['pfs'],
                'ike-version': ikepolicy_db['ike_version'],
                'lifetime': {'units': ikepolicy_db['lifetime']['units'],
                             'value': ikepolicy_db['lifetime']['value']},
            }
        except KeyError as value:
            LOG.error(_LE("[AC]Construct IKE policy info error, "
                          "doesn't contain all fields : %s."), value)
            raise KeyError

        return ikepolicy_info


class ACIPSecpolicyModel(object):
    """ACIPSecpolicyModel"""
    @staticmethod
    def ac_model_format(ipsecpolicy_db, tenant_name):
        """ac_model_format"""
        try:
            ipsecpolicy_info = {
                'uuid': ipsecpolicy_db['id'],
                'name': ipsecpolicy_db['name'],
                'tenant-id': ipsecpolicy_db['tenant_id'],
                'tenant-name': tenant_name,
                'descr': ipsecpolicy_db['description'],
                'transform-protocol':
                    ipsecpolicy_db['transform_protocol'],
                'encapsulation-mode':
                    ipsecpolicy_db['encapsulation_mode'],
                'auth-algorithm': ipsecpolicy_db['auth_algorithm'],
                'encryption-algorithm':
                    ipsecpolicy_db['encryption_algorithm'],
                'pfs': ipsecpolicy_db['pfs'],
                'lifetime': {
                    'units': ipsecpolicy_db['lifetime']['units'],
                    'value': ipsecpolicy_db['lifetime']['value']
                }
            }
        except KeyError as value:
            LOG.error(_LE("[AC]Construct IPSec policy info error, "
                          "doesn't contain all fields %s."), value)
            raise KeyError

        return ipsecpolicy_info


class ACIPSecSiteConnModel(object):
    """ACIPSecSiteConnModel"""
    @staticmethod
    def ac_model_format(ipsec_site_conn_db, tenant_name):
        """ac_model_format"""
        try:
            ipsec_site_connection_info = {
                'uuid': ipsec_site_conn_db['id'],
                'name': ipsec_site_conn_db['name'],
                'tenant-id': ipsec_site_conn_db['tenant_id'],
                'tenant-name': tenant_name,
                'descr': ipsec_site_conn_db['description'],
                'peer-address': ipsec_site_conn_db['peer_address'],
                'peer-id': ipsec_site_conn_db['peer_id'],
                'route-mode': ipsec_site_conn_db['route_mode'],
                'mtu': ipsec_site_conn_db['mtu'],
                'auth-mode': ipsec_site_conn_db['auth_mode'],
                'psk': ipsec_site_conn_db['psk'],
                'initiator': ipsec_site_conn_db['initiator'],
                'ikepolicy-id': ipsec_site_conn_db['ikepolicy_id'],
                'ipsecpolicy-id': ipsec_site_conn_db['ipsecpolicy_id'],
                'vpnservice-id': ipsec_site_conn_db['vpnservice_id'],
                'admin-state-up': ipsec_site_conn_db['admin_state_up'],
                'dpd': {
                    'action': ipsec_site_conn_db['dpd']['action'],
                    'interval': ipsec_site_conn_db['dpd']['interval'],
                    'timeout': ipsec_site_conn_db['dpd']['timeout']
                }
            }
            if ipsec_site_conn_db.get('peer_cidrs'):
                ipsec_site_connection_info['peer-cidrs'] = \
                    ipsec_site_conn_db['peer_cidrs']
            if ipsec_site_conn_db.get('local_ep_group_id'):
                ipsec_site_connection_info['local-ep-group-id'] = \
                    ipsec_site_conn_db['local_ep_group_id']
            if ipsec_site_conn_db.get('peer_ep_group_id'):
                ipsec_site_connection_info['peer-ep-group-id'] = \
                    ipsec_site_conn_db['peer_ep_group_id']
        except KeyError as value:
            LOG.error(_LE("[AC]Construct IPSec site connection info error, "
                          "doesn't contain all fields %s."), value)
            raise KeyError

        return ipsec_site_connection_info


class ACEndPointGroupModel(object):
    """ACEndPointGroupModel"""
    @staticmethod
    def ac_model_format(ep_group_dict, tenant_name):
        """ac_model_format"""
        try:
            ep_group_info = {
                'uuid': ep_group_dict['id'],
                'name': ep_group_dict['name'],
                'tenant-id': ep_group_dict['tenant_id'],
                'tenant-name': tenant_name,
                'type': ep_group_dict['type'],
                'description': ep_group_dict['description'],
                'endpoints': ep_group_dict['endpoints']
            }
        except KeyError as value:
            LOG.error(_LE("[AC] Construct VPN endpoint group info error, "
                          "doesn't contain all fields %s."), value)
            raise KeyError

        return ep_group_info
