#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""ipv6 ns qos policy model"""

from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei._i18n import _LI, _LE

LOG = logging.getLogger(__name__)


class ACIpv6NsQoSpolicyModel(object):
    """ACIpv6NsQoSpolicyModel"""
    @staticmethod
    def ac_model_format(policy_db):
        """ac_model_format"""
        try:
            policy_info = {
                'uuid': policy_db['id'],
                'name': policy_db['name'],
                'tenant-id': policy_db['tenant_id']
            }
            if policy_db.get('description'):
                policy_info["description"] = policy_db['description']
            if policy_db.get('router_id'):
                policy_info["router-id"] = policy_db['router_id']
            if policy_db.get('port_id'):
                policy_info["port-id"] = policy_db['port_id']
            if policy_db.get('qos_policy_id'):
                policy_info["qos-policy-id"] = policy_db['qos_policy_id']

        except KeyError as value:
            LOG.error(_LE("[AC] Key error, "
                          "doesn't contain all fields : %s."), value)
            raise KeyError
        return policy_info
