#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""qos model"""

from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei._i18n import _LI, _LE

LOG = logging.getLogger(__name__)


def _set_qos_rules(policy_info, policy_db):
    bandwidth_limit_rules = []
    dscp_limit_rules = []
    cos_marking_rules = []
    for rule_db in policy_db['rules']:
        LOG.info(_LI('[AC] QoS rule type: %s'), rule_db.rule_type)
        if rule_db.rule_type == 'cos_marking':
            cos_marking_rules.append(
                {
                    "uuid": rule_db['id'],
                    "cos-mark": rule_db['cos_mark'],
                }
            )
        elif rule_db.rule_type in ['bandwidth_limit', 'fip_bandwidth_limit']:
            bandwidth_limit_rule = {
                "uuid": rule_db['id'],
                "qos-policy-id": rule_db['qos_policy_id'],
                "max-kbps": rule_db['max_kbps'],
                "max-burst-kbps": rule_db['max_burst_kbps'],
            }
            if 'direction' in rule_db:
                bandwidth_limit_rule['direction'] = "inbound" \
                    if rule_db['direction'] == "ingress" else "outbound"
            bandwidth_limit_rules.append(bandwidth_limit_rule)
        elif rule_db.rule_type == 'dscp_marking':
            dscp_limit_rules.append(
                {
                    "uuid": rule_db['id'],
                    "dscp-mark": rule_db['dscp_mark'],
                }
            )
    if cos_marking_rules:
        policy_info['qos-cos-marking-rules'] = {
            'qos-cos-marking-rule': cos_marking_rules
        }
    if bandwidth_limit_rules:
        policy_info['qos-bandwidth-limit-rules'] = {
            'qos-bandwidth-limit-rule': bandwidth_limit_rules
        }
    if dscp_limit_rules:
        policy_info['qos-dscp-limit-rules'] = {
            'qos-dscp-limit-rule': dscp_limit_rules
        }


class ACQoSpolicyModel(object):
    """ACQoSpolicyModel"""
    @staticmethod
    def ac_model_format(policy_db):
        """ac_model_format"""
        try:
            policy_info = {
                "uuid": policy_db['id'],
                "name": policy_db['name'],
                "tenant-id": policy_db['tenant_id']
            }

            if policy_db['rules']:
                _set_qos_rules(policy_info, policy_db)
            if policy_db['description']:
                policy_info['description'] = policy_db['description']
        except KeyError as value:
            LOG.error(_LE("[AC] Construct QoS policy info error, "
                          "doesn't contain all fields : %s."), value)
            raise KeyError
        return policy_info
