#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""security group model"""

from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei.drivers.ac.common import constants as ac_const
from networking_huawei._i18n import _LE

LOG = logging.getLogger(__name__)


class ACSecurityGroupModel(object):
    """ACSecurityGroupModel"""
    @staticmethod
    def ac_model_format(security_group_db):
        """ac_model_format"""
        try:
            security_group_info = {
                'uuid': security_group_db['id'],
                'name': security_group_db['name'],
                'tenant-id': security_group_db['tenant_id'],
                'description': security_group_db['description'],
                'security-rules':
                    [x.get('id') for x in
                     security_group_db.get('security_group_rules') or []]
            }
            if security_group_db.get('created_at'):
                security_group_info['created-at'] = \
                    security_group_db['created_at']
            if security_group_db.get('updated_at'):
                security_group_info['updated-at'] = \
                    security_group_db['updated_at']
        except KeyError as ex:
            LOG.error(_LE("[AC] Construct security group info error, "
                          "doesn't contain all fields: %s."), ex)
            return KeyError

        return security_group_info


class ACSecurityGroupRuleModel(object):
    """ACSecurityGroupRuleModel"""

    @staticmethod
    def ac_model_format(security_group_rule_db):
        """ac_model_format"""
        try:
            security_group_rule_info = {
                'id': security_group_rule_db['id'],
                'tenant-id': security_group_rule_db['tenant_id']
            }
            if security_group_rule_db.get('protocol') is not None:
                security_group_rule_info['protocol'] = \
                    security_group_rule_db['protocol']
            if security_group_rule_db.get('direction'):
                security_group_rule_info['direction'] = '%s%s%s' % (
                    ac_const.NEUTRON_CONSTANTS,
                    ac_const.SECURITY_GROUP_DIRECTION,
                    security_group_rule_db['direction'])
            if security_group_rule_db.get('security_group_id'):
                security_group_rule_info['security-group-id'] = \
                    security_group_rule_db['security_group_id']
            if security_group_rule_db.get('remote_group_id'):
                security_group_rule_info['remote-group-id'] = \
                    security_group_rule_db['remote_group_id']
            if security_group_rule_db.get('remote_ip_prefix'):
                security_group_rule_info['remote-ip-prefix'] = \
                    security_group_rule_db['remote_ip_prefix']
            if security_group_rule_db.get('port_range_min') is not None:
                security_group_rule_info['port-range-min'] = \
                    security_group_rule_db['port_range_min']
            if security_group_rule_db.get('port_range_max') is not None:
                security_group_rule_info['port-range-max'] = \
                    security_group_rule_db['port_range_max']
            security_group_rule_info = ACSecurityGroupRuleModel.\
                update_rule_info_erhertype(security_group_rule_db,
                                           security_group_rule_info)
            security_group_rule_info = ACSecurityGroupRuleModel.\
                update_rule_info_rip(security_group_rule_db,
                                     security_group_rule_info)

        except KeyError as ex:
            LOG.error(_LE("[AC] Construct security group rule info error, "
                          "doesn't contain all fields: %s."), ex)
            return KeyError

        return security_group_rule_info

    @staticmethod
    def update_rule_info_erhertype(rule_db, rule_info):
        """update_rule_info_erhertype"""
        if rule_db.get('ethertype'):
            if rule_db['ethertype'] == 'IPv4':
                ethertype = 'v4'
            else:
                ethertype = 'v6'
            rule_info['ethertype'] = '%s%s%s' % (
                ac_const.NEUTRON_CONSTANTS, ac_const.SECURITY_GROUP_ETHER_TYPE,
                ethertype)
        return rule_info

    @staticmethod
    def update_rule_info_rip(rule_db, rule_info):
        """update_rule_info_rip"""
        if not rule_db.get('remote_ip_prefix') and \
                not rule_db.get('remote_group_id'):
            if rule_db.get('ethertype') == 'IPv4':
                rule_info['remote-ip-prefix'] = ac_const.DEFAULT_IPV4_PREFIX
            elif rule_db.get('ethertype') == 'IPv6':
                rule_info['remote-ip-prefix'] = ac_const.DEFAULT_IPV6_PREFIX
        return rule_info
