#!/usr/bin/env python
# coding=utf-8
"""
# @File : ac_bfd_validator.py
# @Time : 2022/9/9
"""
import networking_huawei.drivers.ac.common.constants as ac_const

try:
    from neutron.common.exceptions import NeutronException
except ImportError:
    from neutron_lib.exceptions import NeutronException


class ConfigException(NeutronException):
    message = 'The param(%s:huawei_ac_config.bfd_name) is not configured.' % ac_const.HUAWEI_CONFIG_FILE


class ParamInvalid(NeutronException):
    # bfd_name长度最大64，分隔符占2位，v4或者v6占据2位，subport_id占据36位
    message = 'The length of huawei_ac_config.bfd_name should not exceed %s' % ac_const.PRE_BFD_NAME_MAX_LENGTH


def validate_pre_bfd_name(pre_bfd_name):
    """V2场景中收到exroute处理中，增加预配置BFD名称参数校验"""
    if not pre_bfd_name:
        raise ConfigException()

    if len(pre_bfd_name) > ac_const.PRE_BFD_NAME_MAX_LENGTH:
        raise ParamInvalid()
