#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Sync result plugin"""

from oslo_log import log as logging
from networking_huawei.drivers.ac.extensions.sync_result import \
    sync_result as sync_result
from networking_huawei.drivers.ac.db.sync_result import sync_results_db
from networking_huawei._i18n import _LI
from networking_huawei.drivers.ac.common import constants

LOG = logging.getLogger(__name__)


class HuaweiSyncResultPlugin(sync_result.SyncresultBase,
                             sync_results_db.SyncDbMixin):
    """Implementation of the Huawei AC sync_result Service Plugin."""
    supported_extension_aliases = ['sync_result']

    def __init__(self):
        LOG.info(_LI("[AC] Init huawei sync_result plugin."))
        super(HuaweiSyncResultPlugin, self).__init__()
        LOG.info(_LI("[AC] Initialization finished successfully "
                     "for huawei sync_result plugin."))

    def get_plugin_type(self):
        """get plugin type"""
        return "sync_result"

    def get_plugin_description(self):
        """get plugin description"""
        return 'Huawei sync_results service plugin'

    def get_sync_results(self, context, filters=None, fields=None,
                         sorts=None, limit=None, marker_obj=None,
                         page_reverse=False):
        """get sync results"""
        LOG.info(_LI("[AC] Begin to get sync results."))
        sync_results = super(HuaweiSyncResultPlugin, self). \
            get_db_sync_results_query(context, filters=filters, fields=fields,
                                      sorts=sorts, limit=limit,
                                      marker_obj=marker_obj,
                                      page_reverse=page_reverse)
        if len(sync_results) == 1 and sync_results[0].get('id') and \
                str(sync_results[0].get('id')).isdigit() and \
                int(str(sync_results[0].get('id'))) == \
                constants.SYNC_NO_DIFFERENCE:
            sync_results = []
        return sync_results
