#!/bin/bash

echo "****Check python version start****"
DOWN_VERSION="python-2.7.5-34"
UP_VERSION="python-2.7.5-46"
PYTHON_VERSION=$(rpm -qa | grep "python-2.7.5")
if [ -n "$PYTHON_VERSION" ]; then
    if ([[ $PYTHON_VERSION < $UP_VERSION ]] || [[ $PYTHON_VERSION == $UP_VERSION* ]]) && ([[ $PYTHON_VERSION > $DOWN_VERSION ]] || [[ $PYTHON_VERSION == $DOWN_VERSION* ]]); then
        echo "Error: The python version cannot be within the range of python-2.7.5-34 to python-2.7.5-46, please upgrade the python version"
        echo "The current python version is $PYTHON_VERSION, recommended python version is 'python2.7.5-58.el7.x86_64'"
    fi
    echo "The python version is ok"
else
    echo "Error: Failed to get python version"
    echo "The recommended python version is 'python2.7.5-58.el7.x86_64'"
fi

echo "****Check python version end****"
