#!/usr/bin/env python
# coding=utf-8
import json
import re
import subprocess
import sys
from json import JSONDecodeError

SERVICE_CAPABILITIES_PATTERN = re.compile('service_capabilities = (.+)')


def main():
    cmd = ["cat", "/etc/keystone/keystone.conf"]
    p = subprocess.Popen(
        args=cmd,
        stdout=subprocess.PIPE, stderr=subprocess.PIPE)

    stdout, _ = p.communicate(timeout=5)
    if not stdout:
        return

    keystone_content = str(stdout, 'utf-8')
    res = re.findall(SERVICE_CAPABILITIES_PATTERN, keystone_content)
    if not res:
        return

    try:
        service_capabilities = json.loads(res[0])
    except JSONDecodeError:
        return

    switch_state = sys.argv[1] if len(sys.argv) >= 2 else 'off'
    if 'on' == switch_state:
        service_capabilities['AC'] = {"ReservePreemption": "yes"}
    elif 'AC' in service_capabilities:
        service_capabilities.pop('AC')

    print(json.dumps(service_capabilities))


if __name__ == '__main__':
    main()
