#!/bin/bash
# Copyright 2021 Huawei Technologies Co. Ltd. All rights reserved.

PORT_UPDATE_NUM=0
PORT_ALL_NUM=0
ids=`neutron port-list | awk '{print $2}'`
echo '**********************************************All begin********************************************'
for id in $ids;do 
	echo '==========================================step start==========================================='
	echo "port id: ${id}"
	let PORT_ALL_NUM++
	YUSHU=$(($PORT_UPDATE_NUM % 100))
	echo "mod 100 result is: ${YUSHU}"
	if [ "$PORT_UPDATE_NUM" -gt 0 ] && [ "$YUSHU" -eq 0 ];then
		echo 'sleep 60s'
		sleep 60
	fi   

	if [ "$id" != "id" ] && [ "$id" != "|" ];then
		vif_type=`neutron port-show $id | grep binding:vif_type |awk '{print $4}'`
		echo "=====vif_type is: ${vif_type}"
		device_owner=`neutron port-show ${id} | grep device_owner |awk '{print $4}'`
		echo "=====device_owner is: ${device_owner}"
		security_groups=`neutron port-show ${id} | grep security_groups |awk '{print $4}'`
		echo "=====security_groups is: ${security_groups}"
		admin_state_up=`neutron port-show ${id} | grep admin_state_up |awk '{print $4}'`
		echo "=====admin_state_up is: ${admin_state_up}"
		
		if [ "$security_groups" != "|" ] && [[ $device_owner == compute* ]] && [ $vif_type == "vhostuser" ];then
			echo "begin to update port: ${id}"
			neutron port-update $id --admin_state_up $admin_state_up;
			echo "end to update port: ${id}"
			let PORT_UPDATE_NUM++
		fi
	fi
	echo "port was updated num is: ${PORT_UPDATE_NUM}"
	echo "all produced port num is: ${PORT_ALL_NUM}"
	echo '==========================================step over==========================================='
done
echo '**********************************************All end**********************************************'
