#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""websocket future"""


import threading

from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging

from networking_huawei.common.exceptions import \
    SyncConnectionException, TimeoutException

LOG = logging.getLogger(__name__)


class Future(object):
    """Future"""
    def __init__(self):
        self.callback = None
        self.result = None
        self.event = threading.Event()
        self.error = None

    def sync(self, request_id, method):
        """sync"""
        self.event.clear()

    def register(self, callback):
        """register"""
        self.callback = callback


    def get_result(self, timeout):
        """get_result"""
        self.event.wait(timeout)
        if self.event.isSet() is False:
            self.event.set()
            raise TimeoutException()

        if self.error is not None:
            raise SyncConnectionException(self.error)
        else:
            return self.result

    def notify(self, request, result, error):
        """notify"""
        self.result = result
        self.error = error
        self.event.set()

    def set_error(self, error):
        """set_error"""
        LOG.debug("[AC]Rpc sync function release lock")
        self.error = error
        self.event.set()
