#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""security util"""

import base64
from networking_huawei.drivers.ac.cryptor.cryptor import AESCryptor
from networking_huawei.drivers.ac.cryptor.encrypt import aes_encrypt
from networking_huawei.drivers.ac.cryptor.pbkdf2 import enable_pbkdf2
from networking_huawei.drivers.ac.common import constants as ac_constants
from networking_huawei.drivers.ac.common.util import ACCommonUtil
from networking_huawei.drivers.ac.db.schema import ACDecryptFactorSchema
from networking_huawei.drivers.ac.db.dbif import ACdbInterface
from networking_huawei.drivers.ac.encode_convert import convert_to_bytes


def encrypt_data(text):
    """encrypt_data"""
    aes_cryptor = AESCryptor(None, None, None)

    # get root key
    key = aes_cryptor._get_init_vector()
    v_factory = aes_cryptor._get_cfg_factor()
    root_key = enable_pbkdf2(
        base64.b64decode(convert_to_bytes(key)),
        base64.b64decode(convert_to_bytes(v_factory)))
    session = ACdbInterface().get_session()
    factor_random_db = session.query(ACDecryptFactorSchema). \
        filter_by(id="random").first()

    # generate work key
    if factor_random_db:
        work_key = base64.b64decode(
            convert_to_bytes(factor_random_db['pw_key']))
    else:
        work_key = ACCommonUtil.get_secure_random()

    # encrypt the work key
    if factor_random_db:
        work_key_iv = base64.b64decode(
            convert_to_bytes(factor_random_db['pw_iv']))
    else:
        work_key_iv = ACCommonUtil.get_secure_random()

    cipher_work_key = aes_encrypt(work_key, root_key, work_key_iv)

    password_key = base64.b64encode(
        convert_to_bytes(cipher_work_key))

    # the iv is used to encrypt password
    if factor_random_db:
        pw_iv = base64.b64decode(
            convert_to_bytes(factor_random_db['key_iv']))
    else:
        pw_iv = ACCommonUtil.get_secure_random()
    # save the iv in config file
    password_iv = base64.b64encode(
        convert_to_bytes(pw_iv))

    # save the iv which is used to encrypt th work key
    key_vi = base64.b64encode(convert_to_bytes(work_key_iv))

    data_encrypt = base64.b64encode(convert_to_bytes(
        aes_encrypt(text, work_key, pw_iv)))
    return password_key, password_iv, key_vi, data_encrypt


def decrypt_data(data, data_type=ac_constants.ACCOUNT_SECURE_KEY,
                 pw_key=None, pw_iv=None, key_iv=None):
    """decrypt_data"""
    try:
        cryptor = AESCryptor(pw_key, pw_iv, key_iv)
        if not any([pw_key, pw_iv, key_iv]):
            cryptor.decrypt_dependency(data_type)
        factor = None
        if data_type == ac_constants.WEBSOCKET_SECURE_KEY:
            factor = cryptor.get_websocket_key_factor()
        data_decrypt = cryptor.decrypt_data(
            base64.b64decode(convert_to_bytes(data)), cfg_factor=factor)
    except Exception:
        raise Exception("decrypt data account error")
    return data_decrypt
