# !/usr/bin/env python
# -*- coding:utf-8 -*-
"""
| 功能：AC 配置检查插件数据库相关
| 修改记录：2022-03-16 20:02 创建
"""
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

try:
    from neutron.db import common_db_mixin
except ImportError:
    from networking_huawei.drivers.ac.common import common_db_mixin

from networking_huawei.drivers.ac.db.config_check.ac_config_schema import ACBasicConfig
from networking_huawei.drivers.ac.common.neutron_compatible_util import ac_log

logger = ac_log.getLogger(__name__)


class AcBasicConfigDBMixin(common_db_mixin.CommonDbMixin):
    """ac 配置数据库层"""

    @classmethod
    def create(cls, context, data):
        """创建

        :param context: neutron_lib.context.Context,上下文
        :param data: dict,用字典描述资源值，来自于请求体
        :return: ACBasicConfig
        """
        logger.info('[AC]Begin to create ACConfig:%s,context=%s', data, context)
        result = data if isinstance(data, ACBasicConfig) else ACBasicConfig.from_dict(data)
        with context.session.begin(subtransactions=True):
            context.session.add(result)
            context.session.flush()
        logger.info('[AC]create result=%s', result)
        return result

    def get(self, context, pk_id):
        """查询单条数据

        :param context: neutron_lib.context.Context,上下文
        :param pk_id: str,资源ID
        :return: ACBasicConfig
        """
        logger.info('[AC]Begin to get ACConfig:%s,context=%s', pk_id, context)
        result = self._get_by_id(context, ACBasicConfig, pk_id)
        logger.info('[AC]get result=%s', result)
        return result

    def list(self, context, filters=None, **kwargs):
        """查询多条记录

        :param context: neutron_lib.context.Context,上下文
        :param filters: 过滤条件
        :param kwargs: dict,其它键值对参数,如sorts、limit、marker_obj、page_reverse
        :return: List[ACBasicConfig]
        """
        logger.info('[AC]Begin to list ACConfig:context=%s,filters=%s,kwargs=%s', context, filters, kwargs)
        result = self._get_collection_query(context, ACBasicConfig, filters=filters)
        return result

    def delete(self, context, pk_id):
        """删除数据库指定ID的数据

        :param context: neutron_lib.context.Context,上下文
        :param pk_id: str,资源ID
        :return: ACBasicConfig
        """
        logger.info('[AC]Begin to delete ACConfig:%s,context=%s', pk_id, context)
        result = self._get_by_id(context, ACBasicConfig, pk_id)
        with context.session.begin(subtransactions=True):
            context.session.delete(result)
        logger.info('[AC]delete result=%s', result)
        return result
