#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""ACFirewallruleSchema class """


import sqlalchemy as sa
from oslo_utils import uuidutils

try:
    from neutron.db import model_base
except ImportError:
    from neutron_lib.db import model_base


class ACFirewallruleSchema(model_base.BASEV2):
    """ACFirewallruleSchema"""
    __tablename__ = 'huawei_ac_firewall_rule_addrs'

    id = sa.Column('id', sa.String(36), primary_key=True,
                   nullable=False, default=uuidutils.generate_uuid)
    source_ports = sa.Column('source_ports', sa.String(255), nullable=True)
    destination_ports = sa.Column('destination_ports', sa.String(255), nullable=True)
    source_ip_addresses = sa.Column('source_ip_addresses', sa.PickleType(protocol=2), nullable=True)
    destination_ip_addresses = sa.Column('destination_ip_addresses', sa.PickleType(protocol=2), nullable=True)
