#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""lock exceptions"""

from networking_huawei._i18n import _
try:
    from neutron.common.exceptions import NeutronException
except ImportError:
    from neutron_lib.exceptions import NeutronException


class DBLockException(NeutronException):
    """DBLockException"""
    message = _("[AC] An unknown exception occurred.")


class DBLockFailed(NeutronException):
    """DBLockFailed"""
    message = _("[AC] The DB Lock cannot be acquired for object=%(oid)s in"
                "the session=%(sid)s.")


class UnknownResourceException(DBLockException):
    """UnknownResourceException"""
    message = _('[AC] Could not find lock id for resource %(resource_type)')
