#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: e3666a7c91f5
Revises: d5d93d9ca9e6
Create Date: 2018-03-04 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration

revision = 'e3666a7c91f5'
down_revision = 'd5d93d9ca9e6'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    Create table huawei_ac_dnat.
    """
    if not migration.schema_has_table('huawei_ac_dnat'):
        op.create_table(
            'huawei_ac_dnat',
            sa.Column('id', sa.String(36), nullable=False),
            sa.Column('floating_ip_id', sa.String(36), nullable=False),
            sa.Column('router_id', sa.String(36), nullable=False),
            sa.Column('fixed_port_id', sa.String(36), nullable=False),
            sa.Column('fixed_ip_address', sa.String(64), nullable=False),
            sa.Column('protocol', sa.String(16), nullable=False),
            sa.Column('floating_ip_port', sa.Integer, nullable=False),
            sa.Column('fixed_ip_port', sa.Integer, nullable=False),
            sa.Column('status', sa.String(16), nullable=False),
            sa.PrimaryKeyConstraint('id'),
        )
