#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: x45jfjekcdg6
Revises: x2e4ffedcag4
Create Date: 2020-10-14 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration
from networking_huawei.drivers.ac.db.utcnow import utcnow

# revision identifiers, used by Alembic.
revision = 'x45jfjekcdg6'
down_revision = 'x2e4ffedcag4'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    Create table huawei_ac_alarms.
    """
    if not migration.schema_has_table('huawei_ac_alarms'):
        op.create_table(
            'huawei_ac_alarms',
            sa.Column('seq_num', sa.Integer, autoincrement=True),
            sa.Column('retry_count', sa.Integer),
            sa.Column('description', sa.PickleType, nullable=True),
            sa.Column('inner_id', sa.String(32)),
            sa.Column('type', sa.String(32)),
            sa.Column('level', sa.String(32)),
            sa.Column('host_id', sa.String(128)),
            sa.Column('occur_time', sa.DateTime, default=utcnow()),
            sa.PrimaryKeyConstraint('seq_num')
        )
