#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: x6ehffeddag4
Revises: x6ehffeddag4
Create Date: 2020-09-7 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration
from networking_huawei.drivers.ac.db.utcnow import utcnow

# revision identifiers, used by Alembic.
revision = 'x6ehffeddag4'
down_revision = 'x45jfjekcdg6'
depends_on = None


def upgrade():
    """Initialize Huawei AC  DB.

    New table huawei_ac_websocket_msg.
    """
    if not migration.schema_has_table('huawei_ac_websocket_msg'):
        op.create_table(
            'huawei_ac_websocket_msg',
            sa.Column('id', sa.String(36), nullable=False),
            sa.Column('res_type', sa.String(64)),
            sa.Column('operation', sa.String(64)),
            sa.Column('status', sa.String(64)),
            sa.Column('msg_time', sa.DateTime, default=utcnow()),
            sa.PrimaryKeyConstraint('id', 'operation', 'msg_time')
        )
