#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""ACL2brSchema class """


import sqlalchemy as sa

try:
    from neutron.db import model_base
except ImportError:
    from neutron_lib.db import model_base



class ACSyncResultSchema(model_base.BASEV2):
    """ACL2brSchema class for table huawei_ac_sync_results"""
    __tablename__ = 'huawei_ac_sync_results'
    id = sa.Column(sa.String(255), primary_key=True)
    tenant_name = sa.Column(sa.String(255), nullable=True)
    res_name = sa.Column(sa.String(255), nullable=True)
    res_type = sa.Column(sa.String(50), nullable=False)
    create_time = sa.Column(sa.String(50), nullable=True)
    update_time = sa.Column(sa.String(50), nullable=True)
    status = sa.Column(sa.String(50), nullable=False)
    oper = sa.Column(sa.String(50), nullable=False)
    sync_type = sa.Column(sa.String(50), nullable=False)
    exec_result = sa.Column(sa.String(50), nullable=True)
    error_message = sa.Column(sa.String(255), nullable=True)
