# !/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""
| 功能：neutron 扩展：支持共享BFD功能的扩展路由
| 版本：2022-06-17 15:44 创建
"""
import traceback

from neutron.api import extensions

try:
    from neutron_lib.plugins.constants import L3
except ImportError:
    from neutron.plugins.common.constants import L3_ROUTER_NAT as L3

try:
    from neutron_lib.api.definitions.l3 import RESOURCE_ATTRIBUTE_MAP, ROUTERS, ROUTER
except ImportError:
    ROUTER = 'router'
    from neutron.extensions.l3 import RESOURCE_ATTRIBUTE_MAP, ROUTERS

from networking_huawei.drivers.ac.common.neutron_compatible_util import ac_log
from networking_huawei.drivers.ac.extensions.abstract_neutron_service_extensions import AbstractServiceExt, \
    AcCommonController

LOG = ac_log.getLogger(__name__)


class BfdRouteController(AcCommonController):

    def __init__(self, plugin, *args, **kwargs):
        super(BfdRouteController, self).__init__(plugin, *args, **kwargs)

    def create_exroutes(self, request, body=None, **kwargs):
        """创建bfd route

        :param request: neutron.api.v2.resource.Request,请求
        :param body: dict,请求体。
        :param kwargs: dict,其它参数。neutron.api.v2.resource.resource()以键值对参数传递。
        :return: dict
        """
        return self.create(request, body, **kwargs)

    def list_exroutes(self, request, **kwargs):
        """查询bfd route

        :param request: neutron.api.v2.resource.Request,请求
        :param kwargs: dict,其它参数。neutron.api.v2.resource.resource()以键值对参数传递。
        :return: dict
        """
        return self.index(request, **kwargs)

    def delete_exroutes(self, request, **kwargs):
        """删除bfd route，注意：用的是put请求而不是DELETE，所以body体放到 kwargs['body'] 内

        :param request: neutron.api.v2.resource.Request,请求
        :param kwargs: dict,其它参数。neutron.api.v2.resource.resource()以键值对参数传递。
        :return: dict
        """
        return self.delete(request, **kwargs)


class Ac_bfd_route_ext(AbstractServiceExt):
    """extension of exroute support bfd"""

    @property
    def attributes(self):
        """资源字段清单"""
        return {}

    def get_name(self):
        return 'bfd_router'

    def get_resources(self):
        """get_resources"""
        plugin = self.get_plugin()
        from neutron.api.v2 import resource
        controller = BfdRouteController(plugin)
        try:
            ac_res = resource.Resource(controller,
                                       action_status=dict(create_exroutes=201, delete_exroutes=201, list_exroutes=200))
        except TypeError as e:
            LOG.warning("The version of openstack is old.Don't support define HTTP response status by yourself.%s:%s",
                        e, traceback.format_exc())
            ac_res = resource.Resource(controller)
        resource = extensions.ResourceExtension(
            ROUTERS, ac_res, path_prefix='v2',
            member_actions={'create_exroutes': 'PUT', 'delete_exroutes': 'PUT', 'list_exroutes': 'GET'},
            attr_map=RESOURCE_ATTRIBUTE_MAP.get(ROUTERS, dict()))
        return [resource]
