#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""QosBase class """

try:
    from neutron.common.exceptions import NotFound, InvalidInput
except ImportError:
    from neutron_lib.exceptions import NotFound, InvalidInput


class QosNotFound(NotFound):
    """QosNotFound class"""
    message = "Qos %(qos_id)s could not be found."


class QosInfoParamInvalid(InvalidInput):
    """QosInfoParamInvalid class"""
    message = "Invalid value for Qos: you need input id."
