#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""target group model"""

from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei._i18n import _LE

LOG = logging.getLogger(__name__)


class ACTargetGroupModel(object):
    """ACTargetGroupModel"""

    @staticmethod
    def ac_model_format(target_group):
        """Convert data to AC model"""
        try:

            target_group_to_ac = {
                'name': target_group['name'],
                'tenant-id': target_group['tenant_id']
            }

            if target_group.get('id') is not None:
                target_group_to_ac['uuid'] = target_group['id']

            if target_group.get('description') is not None:
                target_group_to_ac['descr'] = target_group['description']

            if target_group.get('shared') is not None:
                target_group_to_ac['shared'] = target_group['shared']

            if target_group.get('provided_policy_rule_sets') is not None:
                target_group_to_ac['provider-rule-set'] = \
                    target_group['provided_policy_rule_sets']

            if target_group.get('consumed_policy_rule_sets') is not None:
                target_group_to_ac['consumer-rule-set'] = \
                    target_group['consumed_policy_rule_sets']

            if target_group.get('policy_targets') is not None:
                target_group_to_ac['policy-target'] = []
                for policy_target in target_group['policy_targets']:
                    pt_to_ac = {"port-id": policy_target}
                    target_group_to_ac['policy-target'].append(pt_to_ac)

            if target_group.get('subnets') is not None:
                target_group_to_ac['subnet'] = \
                    target_group['subnets']

        except KeyError as value:
            LOG.error(_LE("[AC]Key Error, doesn't contain all fields %s."),
                      value)
            raise KeyError

        return target_group_to_ac
