#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""ACL2BRModel class """

from oslo_log import log as logging
from networking_huawei._i18n import _LE

LOG = logging.getLogger(__name__)


class ACVpcConnectionModel(object):
    """ACVpcConnectionModel class """

    @staticmethod
    def ac_model_format(vpc_conn):
        """Convert data to AC model"""

        try:
            vpc_conn_info = {
                'uuid': vpc_conn['id'],
                'tenant-id': vpc_conn['tenant_id'],
                'local-router-id': vpc_conn['local_router'],
                'local-subnets': vpc_conn['local_subnets'],
                'local-cidrs': vpc_conn['local_cidrs'],
                'local-firewall-enable': vpc_conn['local_firewall_enable'],
                'peer-router-id': vpc_conn['peer_router'],
                'peer-subnets': vpc_conn['peer_subnets'],
                'peer-cidrs': vpc_conn['peer_cidrs'],
                'peer-firewall-enable': vpc_conn['peer_firewall_enable'],
                'mode': vpc_conn['mode'],
                'priority': vpc_conn['priority'],
            }

            if vpc_conn.get('fw_enabled') is not None:
                vpc_conn_info['local-firewall-enable'] = vpc_conn['fw_enabled']
                vpc_conn_info['peer-firewall-enable'] = vpc_conn['fw_enabled']
                vpc_conn_info['mode'] = 1

            if vpc_conn.get('name') and \
                    (vpc_conn['name'].strip() != ''):
                vpc_conn_info['name'] = vpc_conn['name']
            if vpc_conn.get('description'):
                vpc_conn_info['description'] = vpc_conn['description']

        except Exception as value:
            LOG.error(_LE("[AC]Get AC model data error: %s."),
                      value)
            raise value
        return vpc_conn_info
