# !/usr/bin/env python
# -*- coding:utf-8 -*-
"""
| 功能：请求模型
| 版本：2022-04-02 16:02 创建
"""
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
from networking_huawei.drivers.ac.common.ac_config_utils import read_ac_config, AC_CONFIG_FILES


class AcConfigCreateReq:
    """AC配置创建请求模型"""

    def __init__(self, **kwargs):
        self.files = AC_CONFIG_FILES
        self.data = []

        file = kwargs.get('file')
        if file:  # 创建某个文件对应的配置
            self.data.append(read_ac_config(file))
            self.files = (file,)
        else:  # 创建所有的ac配置
            for elem in AC_CONFIG_FILES:
                self.data.append(read_ac_config(elem))

        # 不需要清空数据库配置
        if not kwargs.get('auto_clear', True):
            self.files = tuple()

    def to_dict(self):
        """模型转成字典

        :return: dict
        """
        return {'files': self.files, 'data': [elem.to_dict() for elem in self.data]}
