#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""options"""

import itertools

import networking_huawei
from networking_huawei.drivers.ac.common import config  # noqa
from networking_huawei.drivers.dummy.common import config as d_config  # noqa


def list_dummy_opts():
    """list dummy opts"""
    return [
        ('huawei_dummy_config',
         itertools.chain(networking_huawei.drivers.dummy.
                         common.config.HUAWEI_DUMMY_DRIVER_OPTS))
    ]


def list_ac_opts():
    """list ac opts"""
    return [
        ('huawei_ac_config',
         itertools.chain(networking_huawei.drivers.ac.
                         common.config.HUAWEI_AC_DRIVER_OPTS)),
        ('huawei_ac_agent_config',
         itertools.chain(networking_huawei.drivers.ac.
                         common.config.HUAWEI_AC_AGENT_OPT))
    ]
