#!/bin/sh

VERSION_FILE="/etc/hostos.version"
ZK_SERVICE_CACHE_PARSER_FILE='/usr/bin/install_tool/zk_cache_cfg_parser.py'
dc_admin_name=`python $ZK_SERVICE_CACHE_PARSER_FILE -s cps -t cps-web -c dc_admin_name`

function get_char(){
    stty cbreak -echo
    dd if=/dev/tty bs=1 count=1 2>/dev/null
    stty -cbreak echo
}

if [ -z $1 ]; then
    echo -e "+ Please input ${dc_admin_name}_admin password: \c"
    while :; do
        ret=`get_char`
        if [ x$ret = x ]; then
            echo
            break
        fi
        password="$password$ret"
    done
else
    password=$1
fi

source set_env << EOF > /dev/null 2>&1
1
$password
EOF

cps template-instance-list --service neutron neutron-server |grep `cat /etc/uuid`> /dev/null 2>&1
if [ $? -ne 0 ]; then
    exit 1
fi

echo -e '+ Begin to config agile-controller:'
sleep 1

#service_plugins
echo -e '1. config service_plugins...' 

bak_conf="/root/networking-huawei/tools/neutron_cps_bak.conf"
if [ ! -e "$bak_conf" ]; then
    cp /etc/neutron/neutron.conf /root/networking-huawei/tools/neutron_cps_bak.conf
fi

cps_global_config_file=/etc/huawei/fusionsphere/neutron.neutron-server/cfg/neutron.neutron-server.cfg

PLUGIN_PATH=networking_huawei.drivers.ac.plugins
L3_PLUGINS=$PLUGIN_PATH.l3.ac_l3_router_plugin.HuaweiACL3RouterPlugin
FWAAS_PLUGINS=$PLUGIN_PATH.fwaas.fwaas_plugin.HuaweiACFwaasPlugin
VPNAAS_PLUGINS=$PLUGIN_PATH.vpnaas.vpnaas_plugin.HuaweiIPsecVPNPlugin
HS_FWAAS_PLUGINS=neutron_fwaas.services.firewall.hs_fwaas_plugin.FirewallPlugin
HS_FWAAS_PLUGINS_FLAG=False
if [ -e "$VERSION_FILE" ] && [[ `grep -c "2[12].*" $VERSION_FILE` -eq '1' ]] && [[ `grep -c "22.1" $VERSION_FILE` -ne '1' ]]
then
    SERVICE_PLUGINS=huawei_ac_l2br,huawei_ac_ext,$L3_PLUGINS,$VPNAAS_PLUGINS,huawei_ac_sync_result,huawei_ac_compare_result,huawei_ac_vpc_connection,huawei_ac_snat,huawei_ac_bgp_route
else
    SERVICE_PLUGINS=huawei_ac_l2br,huawei_ac_ext,$L3_PLUGINS,$FWAAS_PLUGINS,$VPNAAS_PLUGINS,huawei_ac_sync_result,huawei_ac_compare_result,huawei_ac_vpc_connection,huawei_ac_snat,huawei_ac_bgp_route
fi

PYTHON_SITE_PATH=$(python2 -c "import os,neutron; print(os.path.abspath(neutron.__file__))" 2>/dev/null |awk -F '/neutron' '{print $1}')
PYTHON_SITE_PATH=$(echo $PYTHON_SITE_PATH|grep python || python3 -c "import os,neutron; print(os.path.abspath(neutron.__file__))" 2>/dev/null |awk -F '/neutron' '{print $1}')
port_forwarding=$(sed '/^port_forwarding =/!d;s/.*=//' $PYTHON_SITE_PATH/neutron-*-py*.egg-info/entry_points.txt)

if [[ -n "$port_forwarding" ]]; then
    SERVICE_PLUGINS=$SERVICE_PLUGINS,huawei_ac_portforwarding
fi

current_service_plugins=`sed '/^service_plugins =/!d;s/.*=//' /etc/neutron/neutron.conf`
if [[ $current_service_plugins == *${HS_FWAAS_PLUGINS}* ]];then
	HS_FWAAS_PLUGINS_FLAG=True
	current_service_plugins=`echo $current_service_plugins | sed 's/'"$HS_FWAAS_PLUGINS"',//g' | sed 's/,'"$HS_FWAAS_PLUGINS"'//g' | sed 's/'"$HS_FWAAS_PLUGINS"'//g'`
	echo "HS_FWAAS_PLUGINS_FLAG is: ${HS_FWAAS_PLUGINS_FLAG}"
	echo "current_service_plugins is: ${current_service_plugins}"
fi
current_service_plugins=`echo $current_service_plugins | sed 's/router,//g' | sed 's/,router//g'`
current_service_plugins=`echo $current_service_plugins | sed 's/vpnaas,//g' | sed 's/,vpnaas//g'`
current_service_plugins=`echo $current_service_plugins | sed 's/firewall,//g' | sed 's/,firewall//g' | sed 's/firewall//g'`
current_service_plugins=`echo $current_service_plugins | sed 's/'"$L3_PLUGINS"',//g' | sed 's/,'"$L3_PLUGINS"'//g' | sed 's/'"$L3_PLUGINS"'//g'`
current_service_plugins=`echo $current_service_plugins | sed 's/'"$FWAAS_PLUGINS"',//g' | sed 's/,'"$FWAAS_PLUGINS"'//g' | sed 's/'"$FWAAS_PLUGINS"'//g'`
current_service_plugins=`echo $current_service_plugins | sed 's/'"$VPNAAS_PLUGINS"',//g' | sed 's/,'"$VPNAAS_PLUGINS"'//g' | sed 's/'"$VPNAAS_PLUGINS"'//g'`
current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_l2br,//g' | sed 's/,huawei_ac_l2br//g' | sed 's/huawei_ac_l2br//g'`
current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_external_whitelist,//g' | sed 's/,huawei_ac_external_whitelist//g' | sed 's/huawei_ac_external_whitelist//g'`
current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_ext,//g' | sed 's/,huawei_ac_ext//g' | sed 's/huawei_ac_ext//g'`
current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_vpc_connection,//g' | sed 's/,huawei_ac_vpc_connection//g' | sed 's/huawei_ac_vpc_connection//g'`
current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_snat,//g' | sed 's/,huawei_ac_snat//g' | sed 's/huawei_ac_snat//g'`
current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_bgp_route,//g' | sed 's/,huawei_ac_bgp_route//g' | sed 's/huawei_ac_bgp_route//g'`
current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_portforwarding,//g' | sed 's/,huawei_ac_portforwarding//g' | sed 's/huawei_ac_portforwarding//g'`
current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_sync_result,//g' | sed 's/,huawei_ac_sync_result//g' | sed 's/huawei_ac_sync_result//g'`
current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_compare_result,//g' | sed 's/,huawei_ac_compare_result//g' | sed 's/huawei_ac_compare_result//g'`

if [[ $current_service_plugins != "" ]]; then
    for plugin in ${current_service_plugins//,/ }; do
        if [[ $SERVICE_PLUGINS != *${plugin}* ]]; then
            SERVICE_PLUGINS=${SERVICE_PLUGINS}","${plugin}
        fi
    done
fi

if [[ $HS_FWAAS_PLUGINS_FLAG = True ]];then
    SERVICE_PLUGINS=`echo $SERVICE_PLUGINS | sed 's/'"$FWAAS_PLUGINS"',//g' | sed 's/,'"$FWAAS_PLUGINS"'//g' | sed 's/'"$FWAAS_PLUGINS"'//g'`
    SERVICE_PLUGINS=${SERVICE_PLUGINS}","${HS_FWAAS_PLUGINS}
    echo "current_service_plugins is: ${current_service_plugins}"
fi

if [[ `grep -c "huawei_ac_l2br" $cps_global_config_file` -eq '1' ]] ||
   [[ `grep -c "huawei_ac_ext" $cps_global_config_file` -eq '1' ]] ||
   [[ `grep -c $L3_PLUGINS $cps_global_config_file` -eq '1' ]] ||
   [[ `grep -c $FWAAS_PLUGINS $cps_global_config_file` -eq '1' ]] ||
   [[ `grep -c $VPNAAS_PLUGINS $cps_global_config_file` -eq '1' ]] ||
   [[ `grep -c "huawei_ac_vpc_connection" $cps_global_config_file` -eq '1' ]] ||
   [[ `grep -c "huawei_ac_sync_result" $cps_global_config_file` -eq '1' ]] ||
   [[ `grep -c "huawei_ac_compare_result" $cps_global_config_file` -eq '1' ]] ||
   [[ `grep -c "huawei_ac_snat" $cps_global_config_file` -eq '1' ]] ||
   [[ `grep -c "huawei_ac_bgp_route" $cps_global_config_file` -eq '1' ]] ||
   [[ `grep -c "huawei_ac_portforwarding" $cps_global_config_file` -eq '1' ]]
then
    echo "      huawei service plugins exists"
else
    cps template-params-update --service neutron neutron-server --parameter service_plugins=$SERVICE_PLUGINS
    cps commit;
fi

#mechanism_drivers
echo -e '2. config mechanism_drivers...' 
exists_mechanism_drivers=`sed '/^mechanism_drivers =/!d;s/.*=//' /etc/neutron/plugins/ml2/ml2_conf.ini`
if [ `grep -c "huawei_ac_ml2" $cps_global_config_file` -eq '1' ]
then
    echo "    huawei_ac_ml2 already exists"
else
    cps template-params-update --service neutron neutron-server --parameter mechanism_drivers=huawei_ac_ml2,${exists_mechanism_drivers// /}
    cps commit
fi

current_extension_drivers=`sed '/^extension_drivers =/!d;s/.*=//' /etc/neutron/plugins/ml2/ml2_conf.ini`
EXTENSION_DRIVERS=`echo $current_extension_drivers`
current_extension_arr=${current_extension_drivers//,/}
if [ `grep -c "huawei_ac_binding" $cps_global_config_file` -eq '1' ]
then
    echo "    huawei_ac_binding already exists"
else
    EXTENSION_DRIVERS=${EXTENSION_DRIVERS}",huawei_ac_binding"
    cps template-params-update --service neutron neutron-server --parameter extension_drivers=$EXTENSION_DRIVERS
    cps commit
fi

#notification_drivers
echo -e '3. config notification_drivers...' 
exists_notification_drivers=`sed '/^notification_drivers =/!d;s/.*=//' /etc/neutron/neutron.conf`
update_nf_drivers=${exists_notification_drivers// /}

if [[ $exists_notification_drivers == '' ]]
then
    update_nf_drivers=message_queue,huawei_ac_qos_driver
else
    if [[ $exists_notification_drivers == *message_queue* ]]
    then
        echo "    message_queue already exists"
    else
        update_nf_drivers=message_queue,$update_nf_drivers
    fi

    if [[ $exists_notification_drivers == *huawei_ac_qos_driver* ]]
    then
        echo "    huawei_ac_qos_driver already exists"
    else
        update_nf_drivers=$update_nf_drivers,huawei_ac_qos_driver
    fi
fi
if [ `grep -c "huawei_ac_qos_driver" $cps_global_config_file` -eq '1' ]
then
    echo "    huawei_ac_qos_driver already exists"
else
    cps template-params-update --service neutron neutron-server --parameter notification_drivers=$update_nf_drivers
    cps commit
fi

#exists_api_extensions_path
echo -e '4. config api_extensions_path...'

api_ext_vpn=$PYTHON_SITE_PATH/neutron_vpnaas/extensions
api_ext_fw=$PYTHON_SITE_PATH/neutron_fwaas/extensions
api_ext_l2br=$PYTHON_SITE_PATH/networking_huawei/drivers/ac/extensions/l2br
api_ext_ex=$PYTHON_SITE_PATH/networking_cascading/exroute_extensions
api_ext_sync=$PYTHON_SITE_PATH/networking_huawei/drivers/ac/extensions/sync

exists_api_extensions_path=`sed '/^api_extensions_path =/!d;s/.*=//' /etc/neutron/neutron.conf`
update_ext_api=${exists_api_extensions_path// /}

if [[ $exists_api_extensions_path == *$api_ext_vpn* ]]
then
    echo "    extensions_path of vpnaas already exists"
else
    update_ext_api=$update_ext_api:$api_ext_vpn
fi

if [[ $exists_api_extensions_path == *$api_ext_fw* ]]
then
    echo "    extensions_path of fw already exists"
else
    update_ext_api=$update_ext_api:$api_ext_fw
fi

if [[ $exists_api_extensions_path == *$api_ext_l2br* ]]
then
    echo "    extensions_path of l2br already exists"
else
    update_ext_api=$update_ext_api:$api_ext_l2br
fi

if [[ $exists_api_extensions_path == *$api_ext_ex* ]]
then
    echo "    extensions_path of exroute already exists"
else
    update_ext_api=$update_ext_api:$api_ext_ex
fi

if [[ $exists_api_extensions_path == *$api_ext_sync* ]]
then
    echo "    extensions_path of sync already exists"
else
    update_ext_api=$update_ext_api:$api_ext_sync
fi

if [[ `grep -c $api_ext_vpn $cps_global_config_file` -eq '1' ]] ||
   [[ `grep -c $api_ext_fw $cps_global_config_file` -eq '1' ]] ||
   [[ `grep -c $api_ext_l2br $cps_global_config_file` -eq '1' ]] ||
   [[ `grep -c $api_ext_sync $cps_global_config_file` -eq '1' ]]
then
    echo "      huawei api extension path exists"
else
    cps template-params-update --service neutron neutron-server --parameter api_extensions_path=$update_ext_api
    cps commit
fi

# enable dry-run
if [[ -e "$VERSION_FILE" ]] && [[ $(grep -c "22.1" $VERSION_FILE) -eq '1' ]]; then
    CUR_PATH=$(dirname $(readlink -f $0))
    on=$(python ${CUR_PATH}/dryrun.py on)
    if [[ $on ]]; then
        cps template-params-update --service keystone keystone --parameter service_capabilities="$on"
        cps commit
        sleep 30
    fi
fi

sleep 3

echo -e '+ Install complete!'
cps template-params-show --service neutron neutron-server
exit 
