#!/bin/bash

function multi_echo(){
    echo -e "+ ============================================================================= +"
}

if [[ -z $1 ]]; then
    multi_echo
    echo -e "+ Please input openstack version [1]Kilo [2]Liberty [3]Mitaka [4]FusionSphere : \c"
    read OPS_VERSION
else
    OPS_VERSION=$1
fi

if [ $OPS_VERSION -ne 4 ]; then
    ORG_VERSION=`neutron-db-manage history | grep "c4818a243f6f," | awk '{print $1}'`
    if [ -z $ORG_VERSION ]; then
        ORG_VERSION=`neutron-db-manage history | grep "head" | awk '{print $3}'`
    fi
    if [ -z $ORG_VERSION ]; then
        ORG_VERSION='kilo'
    fi
fi

INSTALL_PATH=$(cd `dirname $0`; cd ../; pwd)
VERSION_C_FILE=$INSTALL_PATH/networking_huawei/drivers/ac/db/migration/alembic_migrations/versions/c4818a243f6f_huawei_ac_mechanisam_driver.py
VERSION_D_FILE=$INSTALL_PATH/networking_huawei/drivers/ac/db/migration/alembic_migrations/versions/d5d93d9ca9e6_huawei_ac_mechanisam_driver.py

PYTHON_SITE_PATH=$(python2 -c "import os,neutron; print(os.path.abspath(neutron.__file__))" 2>/dev/null |awk -F '/neutron' '{print $1}')
PYTHON_SITE_PATH=$(echo $PYTHON_SITE_PATH|grep python || python3 -c "import os,neutron; print(os.path.abspath(neutron.__file__))" 2>/dev/null |awk -F '/neutron' '{print $1}')
DB_VERSION_PATH=${PYTHON_PATH}/neutron/db/migration/alembic_migrations/versions

RECOVER_TABLES=('huawei_ac_bare_metal_bond', 'huawei_ac_bgp_route', 'huawei_ac_l2brs', 'huawei_ac_port_attributes', 'huawei_ac_res_attributes', 'huawei_ac_vpc_connection')

function get_char(){
    stty cbreak -echo
    dd if=/dev/tty bs=1 count=1 2>/dev/null
    stty -cbreak echo
}

if [ $OPS_VERSION -ne 4 ]; then
    echo -e "+ Please input mysql username: \c"
    read username
    echo -e "+ Please input mysql password: \c"
else
    echo -e "+ Please input gaussdb password: \c"
fi
while :; do
    ret=`get_char`
    if [ x$ret = x ]; then
        echo
        break
    fi
    password="$password$ret"
    printf "*"
done

if [ $OPS_VERSION -ne 4 ]; then
    echo "use neutron" | mysql -u$username -p$password 1>/dev/null 2>/dev/null || { echo -e "+ DB username or password is not correct! Upgrade neutron DB failed!"; multi_echo; exit 1; }
fi

function db_backup(){
    TABLE_LIST=(`echo "use neutron; show tables like '%huawei_ac%';" | mysql -u$username -p$password`)
    rm -rf ${INSTALL_PATH}/tools/sql_backup
    mkdir -p ${INSTALL_PATH}/tools/sql_backup
    for table in ${TABLE_LIST[*]:2:${#TABLE_LIST[*]}}
    do
        mysqldump -u$username -p$password neutron $table > ${INSTALL_PATH}/tools/sql_backup/${table}.sql
    done
}

function db_recover(){
    if [ -e ${INSTALL_PATH}/tools/sql_backup ]; then
        for file in ${INSTALL_PATH}/tools/sql_backup/*
        do
            table=`echo $file | awk -F . '{print $1}' | awk -F / '{print $NF}'`
            if [[ "${RECOVER_TABLES[@]}" =~ "$table" ]]; then
                echo "use neutron; source ${file};" | mysql -u$username -p$password
            fi
        done
    fi
}

function db_clear(){
    TABLE_LIST=(`echo "use neutron; show tables like '%huawei_ac%';" | mysql -u$username -p$password`)
    for table in ${TABLE_LIST[*]:2:${#TABLE_LIST[*]}}
    do
        echo "use neutron; drop table if exists $table;" | mysql -u$username -p$password || return 0
    done
}

function db_upgrade_kilo(){
    echo "use neutron; update alembic_version set version_num = '$ORG_VERSION';" | mysql -u$username -p$password

    sed -i "s/.*\(Revises:\).*/\1 $ORG_VERSION/" $VERSION_C_FILE
    sed -i "s/.*\(down_revision =\).*/\1 '$ORG_VERSION'/" $VERSION_C_FILE

    cp $VERSION_C_FILE $DB_VERSION_PATH
    cp $VERSION_D_FILE $DB_VERSION_PATH
    echo 'd5d93d9ca9e6' > $DB_VERSION_PATH/HEAD
    neutron-db-manage --config-file /etc/neutron/neutron.conf upgrade head 1>/dev/null 2>/dev/null
}

function db_upgrade_liberty(){
    neutron-db-manage --subproject networking-huawei upgrade head 1>/dev/null 2>/dev/null
}

function db_backup_fusionsphere(){
    rm -rf ${INSTALL_PATH}/tools/sql_backup
    mkdir -p ${INSTALL_PATH}/tools/sql_backup
    TABLE_LIST=(`su - gaussdba -c "gsql neutron -W $1 -c \"select table_name from information_schema.tables where table_name like 'HUAWEI%'\""`)
    for table in ${TABLE_LIST[*]:2:${#TABLE_LIST[*]}}
    do
        if [ `echo $table | grep ^HUAWEI` ]; then
            echo -e "+ ${table}: \c"
            su - gaussdba -c "gs_dump neutron -W $1 -a -t $table -f /tmp/${table}.sql" > /dev/null
            su - gaussdba -c "gsql neutron -W $1 -c \"drop table if exists $table\"" > /dev/null
            mv /tmp/${table}.sql ${INSTALL_PATH}/tools/sql_backup
        fi
    done
    su - gaussdba -c "gsql neutron -W $1 -c \"drop type if exists plugin_state;\"" > /dev/null
    su - gaussdba -c "gsql neutron -W $1 -c \"drop type if exists neutron_state;\"" > /dev/null
    su - gaussdba -c "gsql neutron -W $1 -c \"drop type if exists neutron_sync_type;\"" > /dev/null
}

function db_recover_fusionsphere(){
    if [ -e ${INSTALL_PATH}/tools/sql_backup ]; then
        FSP_RECOVER_TABLES=('HUAWEI_AC_L2BRS', 'HUAWEI_AC_PORT_ATTRIBUTES', 'HUAWEI_AC_RES_ATTRIBUTES')
        for file in ${INSTALL_PATH}/tools/sql_backup/*.sql
        do
            table=`echo $file | awk -F . '{print $1}' | awk -F / '{print $NF}'`
            if [ `echo $table | grep ^HUAWEI` ] && [[ "${FSP_RECOVER_TABLES[@]}" =~ "$table" ]]; then
                cp -p $file /tmp
                su - gaussdba -c "gsql neutron -W $1 -f /tmp/${table}.sql" > /dev/null
                rm -f /tmp/${table}.sql
            fi
        done
    fi
}

if [ $OPS_VERSION -eq 1 ]; then
    db_backup
    db_upgrade_kilo
elif [ $OPS_VERSION -eq 2 ] || [ $OPS_VERSION -eq 3 ]; then
    db_backup
    db_upgrade_liberty
elif [ $OPS_VERSION -eq 4 ]; then
    db_backup_fusionsphere $password
    db_upgrade_liberty
    db_recover_fusionsphere $password
fi

echo -e "+ Upgrade neutron DB successful!"
if [[ -z $1 ]]; then
    multi_echo
fi
