#!/bin/bash

SCRIPT_PATH=$(cd $(dirname $0);pwd)
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/"
LOG_FILE="${LOG_PATH}/getextend_NCE_Common.log"

#####################################
#   初始化日志文件
#####################################
function init_upgrade_log()
{
    if [ ! -d ${LOG_PATH} ]
    then
        mkdir -p ${LOG_PATH}
    fi
    [ -f ${LOG_FILE} ] && rm -f ${LOG_FILE}
}

#####################################
#   查询环境是否为异地HA本地部署
#####################################
function get_extend_info()
{
    local script_name="${SCRIPT_PATH}/getextend_nce_common.py"
    
    . /opt/oss/manager/bin/engr_profile.sh
    
    if [ ! -f "${script_name}" ]
    then
        script_name="${script_name}c"
    fi
    python ${script_name} "$@"
    # 更新对应字段
    cd ${SCRIPT_PATH}
    python <<END
import json
with open('extendinfo_NCE_Common.json', 'r') as f_read:
    file_data=json.load(f_read)
file_data.update({"is_manager_domain": "true", "is_co_deployment": "true", "is_pre_upgrade_co_deployment": "true"})
with open('extendinfo_NCE_Common.json', 'w') as f_write:
    json.dump(file_data, f_write)
END
}

function main()
{
    init_upgrade_log
    get_extend_info
}

main $@ >/dev/null 2>&1
exit $?