#!/bin/bash
. ./controller.inc
################################################################################
# Function    : check_agent_float_ip
# Description : The collector floating IP address does not conflict with the collector IP address
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_agent_float_ip()
{
    #the variable count the fail time of check step
    typeset -i error_fail_num=0

    cd /root/EasySuite/888/script/
    /root/EasySuite/888/script/python/bin/python launch.pyc processor -i -exec pre.install.check_items -check_item "install.check_agent_float_ip" >/dev/null 2>&1
    if [[ $? == 0 ]]
    then
        echo " "
        echo "-----------------------------------------------------"
        echo "[successfully]The collector floating IP address is verified successfully."
        echo "-----------------------------------------------------"
        echo " "
    else
        res_ip_check=$(/root/EasySuite/888/script/python/bin/python launch.pyc processor -i -exec pre.install.check_items -check_item "install.check_agent_float_ip")
        echo " "
        echo "-----------------------------------------------------"
        echo "[failed] The collector floating IP address conflicts with other IP addresses."
        IFS=$'@'
        echo ${res_ip_check}
        echo "-----------------------------------------------------"
        echo " "
		echo " " >&2
        ((error_fail_num=error_fail_num+1))
    fi

    if [ ${error_fail_num} -gt 0 ]
    then
        return 1
		#failed
    else
        return 0
    fi
}
