#!/bin/bash
CUR_PATH=$(cd `dirname $0`;pwd)
cd ${CUR_PATH}
. ./controller.inc
################################################################################
# Function    : check_cpu_arch
# Description : check the cpu arch is right.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_cpu_arch()
{
    #the variable count the fail time of check step
    typeset -i error_fail_num=0
    cpu_check_log=$4
    flag_str="custom_check_cpu_arch"

    arch_type=$('arch')
    if [[ $1 == "x86" ]] && [[ $arch_type == "x86_64" ]]
    then
        echo ${flag_str} > ${cpu_check_log}
        echo " " >> ${cpu_check_log}
        echo "-----------------------------------------------------" >> ${cpu_check_log}
        echo "[successfully]The cpu arch is right, please continue." >> ${cpu_check_log}
        echo "-----------------------------------------------------" >> ${cpu_check_log}
        echo " " >> ${cpu_check_log}
    elif [[ $1 == "arm" ]] && [[ $arch_type == "aarch64" ]]
    then
        echo ${flag_str} > ${cpu_check_log}
        echo " "
        echo "-----------------------------------------------------" >> ${cpu_check_log}
        echo "[successfully]The cpu arch is right, please continue." >> ${cpu_check_log}
        echo "-----------------------------------------------------" >> ${cpu_check_log}
        echo " " >> ${cpu_check_log}
    else
        echo ${flag_str}
        flag_str=""  # 将字符串变为空串，防止os不对的时候再打一遍头标志
        echo " "
        echo "-----------------------------------------------------"
        echo "[failed]"
        echo "[ERROR message]: The CPU architecture selected on the configuration page does not match that of the server."
        echo "-----------------------------------------------------"
        echo "[Solution]: Select the same CPU architecture as the server during installation."
        echo "-----------------------------------------------------"
        echo " "
        echo " " >&2
        ((error_fail_num=error_fail_num+1))
    fi

    os_type=$(cat /etc/os-release | grep '^NAME'|awk -F'=' '{print $2}')
    if [[ $2 == "true" ]]
    then
        if [[ $os_type == *"SLES"* ]] && [[ $3 == "SLES" ]]
        then
            echo " " >> ${cpu_check_log}
            echo "-----------------------------------------------------" >> ${cpu_check_log}
            echo "[successfully]The os type is right, please continue." >> ${cpu_check_log}
            echo "-----------------------------------------------------" >> ${cpu_check_log}
            echo " " >> ${cpu_check_log}
        elif [[ $os_type == *"EulerOS"* ]] && [[ $3 == "EulerOS" ]]
        then
            echo " " >> ${cpu_check_log}
            echo "-----------------------------------------------------" >> ${cpu_check_log}
            echo "[successfully]The os type is right, please continue." >> ${cpu_check_log}
            echo "-----------------------------------------------------" >> ${cpu_check_log}
            echo " " >> ${cpu_check_log}
        elif [[ $os_type == *"Kylin"* ]] && [[ $3 == "Kylin" ]]
        then
            echo " " >> ${cpu_check_log}
            echo "-----------------------------------------------------" >> ${cpu_check_log}
            echo "[successfully]The os type is right, please continue." >> ${cpu_check_log}
            echo "-----------------------------------------------------" >> ${cpu_check_log}
            echo " " >> ${cpu_check_log}
        else
            echo ${flag_str}
            echo " "
            echo "-----------------------------------------------------"
            echo "[failed]"
            echo "[ERROR message]: The OS type selected on the configuration page does not match the server type."
            echo "-----------------------------------------------------"
            echo "[Solution]: Select the same OS type as the server during installation."
            echo "-----------------------------------------------------"
            echo " "
        echo " " >&2
            ((error_fail_num=error_fail_num+1))
        fi
    else
        if [[ $os_type == *"SLES"* || $os_type == *"EulerOS"* || $os_type == *"Kylin"* ]]
        then
            echo " " >> ${cpu_check_log}
            echo "-----------------------------------------------------" >> ${cpu_check_log}
            echo "[successfully]The os type is right, please continue." >> ${cpu_check_log}
            echo "-----------------------------------------------------" >> ${cpu_check_log}
            echo " " >> ${cpu_check_log}
        else
            echo "custom_check_cpu_arch"
            echo " "
            echo "-----------------------------------------------------"
            echo "[failed]"
            echo "[ERROR message]: Currently, only SUSE 12.5 and EulerOS are supported."
            echo "-----------------------------------------------------"
            echo "[Solution]: Replace the OS with the OS supported by the product."
            echo "-----------------------------------------------------"
            echo " "
            echo " " >&2
            ((error_fail_num=error_fail_num+1))
        fi
    fi
    os_lang_lc_ctype=$(locale | grep 'LC_CTYPE'|awk -F'=' '{print $2}')
    os_lang_lc_all=$(locale | grep 'LC_ALL'|awk -F'=' '{print $2}')
    if [[ $os_lang_lc_ctype =~ "en_US.UTF-8" || $os_lang_lc_all =~ "en_US.UTF-8" ]]
    then
        echo " " >> ${cpu_check_log}
        echo "-----------------------------------------------------" >> ${cpu_check_log}
        echo "[successfully]The operating system language is right, please continue." >> ${cpu_check_log}
        echo "-----------------------------------------------------" >> ${cpu_check_log}
        echo " " >> ${cpu_check_log}
    else
        echo "custom_check_cpu_arch"
        echo " "
        echo "-----------------------------------------------------"
        echo "[failed]"
        echo "[ERROR message]: Currently, Only en_US.UTF-8 is supported."
        echo "-----------------------------------------------------"
        echo "[Solution]: Change the operating system language to en_US.UTF-8."
        echo "-----------------------------------------------------"
        echo " "
        echo " " >&2
        ((error_fail_num=error_fail_num+1))
    fi

    if [ ${error_fail_num} -gt 0 ]
    then
        return 1
        #failed
    else
        return 0
    fi
}

function main()
{
    #the variable count the fail time of check step
    typeset -i fail_num=0
    log_file='/opt/install_check/check_cpu_arch.log'
    #step1: 检查客户选择的CPU框架是否与服务器匹配
    check_cpu_arch $1 $2 $3 ${log_file}
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
        echo "custom_check_cpu_arch"
    else
        echo "[successfully] Checking Operating System Information successfully !" >> ${log_file}
        echo "custom_check_cpu_arch" >> ${log_file}
    fi

    if [ ${fail_num} -gt 0 ]
    then
        echo "===========================CHECKING ENVIRONMENT FAILED=============================="
        echo "===================================================================================="
        rm -rf /opt/install_check
        return 1
    fi
}
main $@