#!/bin/bash
. ./controller.inc

STANDALNE_MEMORY_128=160
CLUSTER_MEMORY_128=190

################################################################################
# Function    : check_memory
# Description : check the memory is right.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_memory()
{
    #the variable count the fail time of check step
    typeset -i error_fail_num=0
    success_flag1=0
    if [[ x"$3" != x && $3 != "fabric_collect_service" ]] || [[ x"$3" == x ]];then
        if [[ x"$2" != x ]] && [[ $2 -eq 1 ]];then
            check_standalone_hld_memory $1
            success_flag1=$?
        fi
        if [[ x"$2" != x ]] && [[ $2 -gt 1 ]];then
            check_cluster_hld_memory $1
            success_flag1=$?
        fi
    fi

	if [[  ${success_flag1} == 0 ]]
	then
		cd /root/EasySuite/888/script/
		res_mem=$(/root/EasySuite/888/script/python/bin/python launch.pyc processor -i -exec pre.install.check_items -check_item "install.check_left_mem")
		success_flag2=$?

		if [[ ${success_flag2} == 0 ]]
		then
			echo " "
			echo "-----------------------------------------------------"
			echo "[successfully]The remaining memory meets the installation specifications, please continue."
			echo "-----------------------------------------------------"
			echo " "
		else
			echo " "
			echo "-----------------------------------------------------"
			echo "[failed]"
			IFS=$'@'
			echo ${res_mem}
			echo "-----------------------------------------------------"
			echo " "
			echo " " >&2
			((error_fail_num=error_fail_num+1))
		fi
	fi

    if [ ${error_fail_num} -gt 0 ]
    then
        return 1
        #failed
    else
        return 0
    fi
}

function check_standalone_hld_memory()
{
    # only total memory > 160G support 256G
    node_total_memory=$(free -g | grep 'Mem:' | awk '{print $2}')
    if [[ $1 = standalone_hld_disk && ${node_total_memory} -lt STANDALNE_MEMORY_128 ]];then
        echo "-----------------------------------------------------"
        echo "[failed][ERROR message]: The server memory is ${node_total_memory}G, which is less than the planned value."
        echo "[Solution]:Replace a server with a large memory."
        echo "-----------------------------------------------------"
        ((error_fail_num=error_fail_num+1))
		return 1
    else
        return 0
    fi
}

function check_cluster_hld_memory()
{
    # only total memory > 160G support 256G
    node_total_memory=$(free -g | grep 'Mem:' | awk '{print $2}')
    if [[ $1 = mem_256g && ${node_total_memory} -lt CLUSTER_MEMORY_128 ]];then
        echo "-----------------------------------------------------"
        echo "[failed][ERROR message]: The server memory is ${node_total_memory}G, which is less than the planned value."
        echo "[Solution]:Replace a server with a large memory."
        echo "-----------------------------------------------------"
        ((error_fail_num=error_fail_num+1))
		return 1
    else
        return 0
    fi
}
