#!/bin/bash
. ./controller.inc
################################################################################
# Function    : check_install
# Description : check installed.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_install()
{
    #the variable count the fail time of check step
    typeset -i error_fail_num=0

    cd /root/EasySuite/888/script/
    res_install=$(/root/EasySuite/888/script/python/bin/python launch.pyc processor -i -exec pre.install.check_items -check_item "install.check_install")
    if [[ $? == 0 ]]
    then
        echo " "
        echo "-----------------------------------------------------"
        echo "[successfully]The product is not installed, please continue."
        echo "-----------------------------------------------------"
        echo " "
    else
        echo " "
        echo "-----------------------------------------------------"
        echo "[failed]"
        IFS=$'@'
        echo ${res_install}
        echo "[uninstall command] if you want to uninstall the product, Please refer to Product Documentation > Installation Guide > Single-Node System Installation Guide > Single-Node System Uninstallation."
        echo "-----------------------------------------------------"
        echo " "
        echo " " >&2
        ((error_fail_num=error_fail_num+1))
    fi

    if [ ${error_fail_num} -gt 0 ]
    then
        return 1
        #failed
    else
        return 0
    fi
}
