#!/bin/bash
. ./controller.inc
################################################################################
# Function    : check_network_config
# Description : check network configuration is right.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_network_config()
{
    #the variable count the fail time of check step
    typeset -i error_fail_num=0


    cd /root/EasySuite/888/script/
    res_e_initparm=$(/root/EasySuite/888/script/python/bin/python launch.pyc processor -i -exec pre.install.init_param <<eof
${os_root_user_pwd}
eof
)
    if [[ $? != 0 ]]
    then
        echo "custom_check_init_network_config"
        echo " "
        echo "-----------------------------------------------------"
        echo "[init_param failed]The network configuration not meets installation specifications, please confirm it."
        IFS=$'@'
        echo ${res_e_initparm#'es_input: os_root_user_pwd'}
        echo "-----------------------------------------------------"
        echo " "
		echo " " >&2
        ((error_fail_num=error_fail_num+1))
    fi

    if [ ${error_fail_num} -gt 0 ]
    then
        return 1
    fi

    # input_check
    cd /root/EasySuite/888/script/
    res_input_check=$(/root/EasySuite/888/script/python/bin/python launch.pyc processor -i -exec pre.install.input_check <<eof
${os_root_user_pwd}
${lld_outer_ntp_mmvalue}
${lld_outer_ntp_mmvalue_bak_1}
${lld_outer_ntp_mmvalue_bak_2}
eof
)
    if [[ $? == 0 ]]
    then
        echo " "
        echo "custom_check_init_network_config"
        echo "-----------------------------------------------------"
        echo "[successfully]The network configuration meets installation specifications, please continue."
        echo "-----------------------------------------------------"
        echo " "
    else
        echo "custom_check_init_network_config"
        echo " "
        echo "-----------------------------------------------------"
        echo "[failed]The network configuration not meets installation specifications, please confirm it."
        IFS=$'@'
        echo ${res_input_check#'es_input: os_root_user_pwdes_input: lld_outer_ntp_mmvaluees_input: lld_outer_ntp_mmvalue_bak_1es_input: lld_outer_ntp_mmvalue_bak_2'}
        echo "-----------------------------------------------------"
        echo " "
		echo " " >&2
        ((error_fail_num=error_fail_num+1))
    fi

    if [ ${error_fail_num} -gt 0 ]
    then
        return 1
		#failed
    else
        return 0
    fi
}