#!/bin/bash
. ./controller.inc
################################################################################
# Function    : check_ip_config
# Description : check the ip config is right.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_ip_config()
{
    #the variable count the fail time of check step
    typeset -i error_fail_num=0

    southbound_card=$1
    northbound_card=$2
    ip_config=$(ip a | grep -E 'secondary ${southbound_card}|secondary ${northbound_card}')
    if [[ $? -ne 0 ]]
    then
        echo " "
        echo "-----------------------------------------------------"
        echo "[successfully]The ip config right, please continue."
        echo "-----------------------------------------------------"
        echo " "
    else
        echo " "
        echo "-----------------------------------------------------"
        echo "[failed]"
        echo "[ERROR message]: Unexpected floating IP found, the floating IP address that contains 'secondary'."
        echo "-----------------------------------------------------"
        echo "[Solution]: The command 'ip a' output contains abnormal items. Delete the floating IP address that contains 'secondary'."
        echo "-----------------------------------------------------"
        echo " "
		echo " " >&2
        ((error_fail_num=error_fail_num+1))
    fi

    if [ ${error_fail_num} -gt 0 ]
    then
        return 1
		#failed
    else
        return 0
    fi
}
