#!/bin/bash
. ./controller.inc
################################################################################
# Function    : scale_check_exists_collector
# Description : Checking existing collector clusters status contains only one collector
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function scale_check_exists_collector()
{
    #the variable count the fail time of check step
    typeset -i error_fail_num=0

    cd /root/EasySuite/888/script/
    res_disk_space=$(/root/EasySuite/888/script/python/bin/python launch.pyc processor -i -exec pre.install.check_items -check_item "scale.scale_check_exists_collector")
    if [[ $? == 0 ]]
    then
        echo " "
        echo "-----------------------------------------------------"
        echo "[successfully]The Information filled in the form Existing collector clusters where nodes are to be added meets installation specifications, please continue."
        echo "-----------------------------------------------------"
        echo " "
    else
        echo " "
        echo "-----------------------------------------------------"
        echo "[failed]The Information filled in the form Existing collector clusters where nodes are to be added not meets installation specifications, please confirm it."
        IFS=$'@'
        echo ${res_disk_space}
        echo "-----------------------------------------------------"
        echo " "
        echo " " >&2
        ((error_fail_num=error_fail_num+1))
    fi

    if [ ${error_fail_num} -gt 0 ]
    then
        return 1
        #failed
    else
        return 0
    fi
}
