#!/bin/bash
. ./controller.inc
################################################################################
# Function    : check_fi_mmvalue
# Description : check the fi_mmvalue is right.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_north_south_divided()
{
    #the variable count the fail time of check step
    typeset -i error_fail_num=0

    cat /root/EasySuite/666/conf/config.properties | grep ^north_south_divided | grep $1 > /dev/null 2>&1
    if [[ $? -eq 0 ]]
    then
        echo " "
        echo "-----------------------------------------------------"
        echo "[successfully]The status of north_south_divided is right, please continue."
        echo "-----------------------------------------------------"
        echo " "
    else
        echo " "
        echo "-----------------------------------------------------"
        echo "[failed]"
        echo "[ERROR message]: The southbound and northbound isolation status cannot be detected."
        echo "-----------------------------------------------------"
        echo "[Solution]: This check depends on the network check."
        echo "-----------------------------------------------------"
        echo " "
        echo " " >&2
        ((error_fail_num=error_fail_num+1))
    fi

    if [ ${error_fail_num} -gt 0 ]
    then
        return 1
        #failed
    else
        return 0
    fi
}
